/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import android.graphics.Bitmap;
import android.os.Message;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.openqa.selenium.Alert;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.android.library.AndroidWebDriver;
import org.openqa.selenium.android.library.WebDriverWebView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChromeClient
extends WebChromeClient {
    private final AndroidWebDriver driver;
    private static BiMap<WebView, Alert> unhandledAlerts = HashBiMap.create();
    private final WebChromeClient delegate;
    private final WebDriverWebView wdview;

    public ChromeClient(AndroidWebDriver driver, WebDriverWebView wdview, WebChromeClient client) {
        this.driver = driver;
        this.wdview = wdview;
        this.delegate = client == null ? new WebChromeClient() : client;
    }

    public void onCloseWindow(WebView window) {
        unhandledAlerts.remove((Object)window);
        this.driver.getViewManager().removeView(window);
        this.delegate.onCloseWindow(window);
    }

    public boolean onCreateWindow(WebView view, boolean dialog, boolean userGesture, Message resultMsg) {
        WebView newView = this.wdview.create();
        WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
        transport.setWebView(newView);
        resultMsg.sendToTarget();
        this.driver.getViewManager().addView(newView);
        return this.delegate.onCreateWindow(view, dialog, userGesture, resultMsg);
    }

    public void onRequestFocus(WebView view) {
        this.delegate.onRequestFocus(view);
    }

    public void onProgressChanged(WebView view, int newProgress) {
        if (newProgress == 100 && this.driver.getLastUrlLoaded() != null && this.driver.getLastUrlLoaded().equals(view.getUrl())) {
            this.driver.notifyPageDoneLoading();
        }
        this.delegate.onProgressChanged(view, newProgress);
    }

    public void onReceivedTitle(WebView view, String title) {
        this.delegate.onReceivedTitle(view, title);
    }

    public void onReceivedIcon(WebView view, Bitmap icon) {
        this.delegate.onReceivedIcon(view, icon);
    }

    public void onReceivedTouchIconUrl(WebView view, String url, boolean precomposed) {
        this.delegate.onReceivedTouchIconUrl(view, url, precomposed);
    }

    public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        this.delegate.onShowCustomView(view, callback);
    }

    public void onShowCustomView(View view, int requestedOrientation, WebChromeClient.CustomViewCallback callback) {
        this.delegate.onShowCustomView(view, requestedOrientation, callback);
    }

    public void onHideCustomView() {
        this.delegate.onHideCustomView();
    }

    public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
        unhandledAlerts.put((Object)view, (Object)new AndroidAlert(message, result));
        return this.delegate.onJsAlert(view, url, message, result);
    }

    public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
        unhandledAlerts.put((Object)view, (Object)new AndroidAlert(message, result));
        return this.delegate.onJsConfirm(view, url, message, result);
    }

    public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
        unhandledAlerts.put((Object)view, (Object)new AndroidAlert(message, (JsResult)result, defaultValue));
        return this.delegate.onJsPrompt(view, url, message, defaultValue, result);
    }

    public boolean onJsBeforeUnload(WebView view, String url, String message, JsResult result) {
        return super.onJsBeforeUnload(view, url, message, result);
    }

    public void onExceededDatabaseQuota(String url, String databaseIdentifier, long currentQuota, long estimatedSize, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
        this.delegate.onExceededDatabaseQuota(url, databaseIdentifier, currentQuota, estimatedSize, totalUsedQuota, quotaUpdater);
    }

    public void onReachedMaxAppCacheSize(long spaceNeeded, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
        this.delegate.onReachedMaxAppCacheSize(spaceNeeded, totalUsedQuota, quotaUpdater);
    }

    public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
        this.delegate.onGeolocationPermissionsShowPrompt(origin, callback);
    }

    public void onGeolocationPermissionsHidePrompt() {
        this.delegate.onGeolocationPermissionsHidePrompt();
    }

    public boolean onJsTimeout() {
        return this.delegate.onJsTimeout();
    }

    public void onConsoleMessage(String message, int lineNumber, String sourceID) {
        this.delegate.onConsoleMessage(message, lineNumber, sourceID);
    }

    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        return this.delegate.onConsoleMessage(consoleMessage);
    }

    public Bitmap getDefaultVideoPoster() {
        return this.delegate.getDefaultVideoPoster();
    }

    public View getVideoLoadingProgressView() {
        return this.delegate.getVideoLoadingProgressView();
    }

    public void getVisitedHistory(ValueCallback<String[]> callback) {
        this.delegate.getVisitedHistory(callback);
    }

    public static Alert getAlertForView(WebView view) {
        return (Alert)unhandledAlerts.get((Object)view);
    }

    public static void removeAllAlerts() {
        unhandledAlerts.clear();
    }

    public static void removeAlertForView(WebView view) {
        unhandledAlerts.remove((Object)view);
    }

    private static void removeAlert(Alert alert) {
        unhandledAlerts.inverse().remove((Object)alert);
    }

    private class AndroidAlert
    implements Alert {
        private final String message;
        private final JsResult result;
        private String textToSend = null;
        private final String defaultValue;

        public AndroidAlert(String message, JsResult result) {
            this(message, result, null);
        }

        public AndroidAlert(String message, JsResult result, String defaultValue) {
            this.message = message;
            this.result = result;
            this.defaultValue = defaultValue;
        }

        public void accept() {
            ChromeClient.removeAlert(this);
            if (this.isPrompt()) {
                JsPromptResult promptResult = (JsPromptResult)this.result;
                String result = this.textToSend == null ? this.defaultValue : this.textToSend;
                promptResult.confirm(result);
            } else {
                this.result.confirm();
            }
        }

        private boolean isPrompt() {
            return this.result instanceof JsPromptResult;
        }

        public void dismiss() {
            ChromeClient.removeAlert(this);
            this.result.cancel();
        }

        public String getText() {
            return this.message;
        }

        public void sendKeys(String keys) {
            if (!this.isPrompt()) {
                throw new ElementNotVisibleException("Alert did not have text field");
            }
            this.textToSend = (this.textToSend == null ? "" : this.textToSend) + keys;
        }
    }
}

