/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import android.os.SystemClock;
import android.view.MotionEvent;
import android.webkit.WebView;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.android.library.AndroidAtoms;
import org.openqa.selenium.android.library.AndroidCoordinates;
import org.openqa.selenium.android.library.AndroidWebDriver;
import org.openqa.selenium.android.library.EventSender;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.internal.WrapsElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidWebElement
implements WebElement,
SearchContext,
WrapsDriver,
Locatable {
    private final AndroidWebDriver driver;
    private final String elementId;
    private AndroidCoordinates coordinates;
    private FindByImpl findsBy;
    private Object syncObject = new Object();
    private volatile boolean done;
    private static final String LOCATOR_ID = "id";
    private static final String LOCATOR_LINK_TEXT = "linkText";
    private static final String LOCATOR_PARTIAL_LINK_TEXT = "partialLinkText";
    private static final String LOCATOR_NAME = "name";
    private static final String LOCATOR_TAG_NAME = "tagName";
    private static final String LOCATOR_XPATH = "xpath";
    private static final String LOCATOR_CSS_SELECTOR = "css";
    private static final String LOCATOR_CLASS_NAME = "className";

    AndroidWebElement(AndroidWebDriver driver, String elementId) {
        this.driver = driver;
        this.elementId = elementId;
        this.findsBy = new FindByImpl();
    }

    String getId() {
        return this.elementId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof WebElement)) {
            return false;
        }
        WebElement e = (WebElement)o;
        if (e instanceof WrapsElement) {
            e = ((WrapsElement)o).getWrappedElement();
        }
        if (!(e instanceof AndroidWebElement)) {
            return false;
        }
        return this.elementId.equals(((AndroidWebElement)e).getId());
    }

    public int hashCode() {
        return this.elementId.hashCode();
    }

    private Point getCenterCoordinates() {
        if (!this.isDisplayed()) {
            throw new ElementNotVisibleException("This WebElement is not visisble and may not be clicked.");
        }
        this.driver.setEditAreaHasFocus(false);
        Point topLeft = this.getLocation();
        String sizeJs = "var w = 0; h = 0;if (arguments[0].getClientRects && arguments[0].getClientRects()[0]) {  w = arguments[0].getClientRects()[0].width;  h = arguments[0].getClientRects()[0].height; } else {  w = arguments[0].offsetWidth;  h = arguments[0].offsetHeight;}; return w + ',' + h;";
        String[] result = ((String)this.driver.executeScript(sizeJs, this)).split(",");
        return new Point(topLeft.x + Integer.parseInt(result[0]) / 2, topLeft.y + Integer.parseInt(result[1]) / 2);
    }

    public void click() {
        Point center = this.getCenterCoordinates();
        long downTime = SystemClock.uptimeMillis();
        ArrayList events = Lists.newArrayList();
        MotionEvent downEvent = MotionEvent.obtain((long)downTime, (long)SystemClock.uptimeMillis(), (int)0, (float)center.x, (float)center.y, (int)0);
        events.add(downEvent);
        MotionEvent upEvent = MotionEvent.obtain((long)downTime, (long)SystemClock.uptimeMillis(), (int)1, (float)center.x, (float)center.y, (int)0);
        events.add(upEvent);
        this.driver.resetPageIsLoading();
        EventSender.sendMotion(events, this.driver.getWebView(), this.driver.getActivity());
        this.driver.waitForPageToLoad();
    }

    public void submit() {
        String tagName = this.getTagName();
        if ("button".equalsIgnoreCase(tagName) || "submit".equalsIgnoreCase(this.getAttribute("type")) || "img".equalsIgnoreCase(tagName)) {
            this.click();
        } else {
            this.driver.resetPageIsLoading();
            this.driver.executeAtom(AndroidAtoms.SUBMIT.getValue(), this);
            this.driver.waitForPageToLoad();
        }
    }

    public void clear() {
        this.driver.executeAtom(AndroidAtoms.CLEAR.getValue(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKeys(final CharSequence ... value) {
        if (value == null || value.length == 0) {
            return;
        }
        if (!this.isEnabled()) {
            throw new InvalidElementStateException("Cannot send keys to disabled element.");
        }
        this.click();
        this.driver.waitUntilEditAreaHasFocus();
        this.driver.executeScript("arguments[0].focus();arguments[0].value=arguments[0].value;", this);
        final WebView view = this.driver.getWebView();
        this.done = false;
        long end = System.currentTimeMillis() + 3000L;
        this.driver.getActivity().runOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = AndroidWebElement.this.syncObject;
                synchronized (object) {
                    EventSender.sendKeys(view, AndroidWebElement.this.driver.getActivity(), value);
                    AndroidWebElement.this.done = true;
                    AndroidWebElement.this.syncObject.notify();
                }
            }
        });
        while (!this.done && System.currentTimeMillis() < end) {
            Object object = this.syncObject;
            synchronized (object) {
                try {
                    this.syncObject.wait();
                }
                catch (InterruptedException e) {
                    throw new WebDriverException("Error while sending keys.", (Throwable)e);
                }
            }
        }
    }

    public String getTagName() {
        return (String)this.driver.executeScript("return arguments[0].tagName", this);
    }

    public String getAttribute(String name) {
        return (String)this.driver.executeAtom(AndroidAtoms.GET_ATTRIBUTE_VALUE.getValue(), this, name);
    }

    public boolean isSelected() {
        return (Boolean)this.driver.executeAtom(AndroidAtoms.IS_SELECTED.getValue(), this);
    }

    public boolean isEnabled() {
        return (Boolean)this.driver.executeAtom(AndroidAtoms.IS_ENABLED.getValue(), this);
    }

    public String getText() {
        return (String)this.driver.executeAtom(AndroidAtoms.GET_TEXT.getValue(), this);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this.findsBy);
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this.findsBy);
    }

    FindByImpl getFinder() {
        return this.findsBy;
    }

    private List<WebElement> lookupElements(String strategy, String locator) {
        if (this.elementId.equals("")) {
            return (List)this.driver.executeAtom(AndroidAtoms.FIND_ELEMENTS.getValue(), strategy, locator);
        }
        return (List)this.driver.executeAtom(AndroidAtoms.FIND_ELEMENTS.getValue(), strategy, locator, this);
    }

    private WebElement lookupElement(String strategy, String locator) {
        WebElement el = this.elementId.equals("") ? (WebElement)this.driver.executeAtom(AndroidAtoms.FIND_ELEMENT.getValue(), strategy, locator) : (WebElement)this.driver.executeAtom(AndroidAtoms.FIND_ELEMENT.getValue(), strategy, locator, this);
        if (el == null) {
            throw new NoSuchElementException("Could not find element with " + strategy + ": " + locator);
        }
        return el;
    }

    private String normalize(String text) {
        String nbsp = new String(new char[]{'\u00a0'});
        return text.replaceAll("\\s+(" + nbsp + ")+\\s+", "$1").replace('\u00a0', ' ').replaceAll("\n+", "\n").replaceAll("\r|\t", "").trim();
    }

    public void dragAndDropBy(int moveRightBy, int moveDownBy) {
        throw new UnsupportedOperationException("Action not supported.");
    }

    public void dragAndDropOn(AndroidWebElement element) {
        throw new UnsupportedOperationException("Action not supported.");
    }

    public Point getLocation() {
        Map map = (Map)this.driver.executeAtom(AndroidAtoms.GET_TOP_LEFT_COORDINATES.getValue(), this);
        return new Point(((Long)map.get("x")).intValue(), ((Long)map.get("y")).intValue());
    }

    public Dimension getSize() {
        Map map = (Map)this.driver.executeAtom(AndroidAtoms.GET_SIZE.getValue(), this);
        return new Dimension(((Long)map.get("width")).intValue(), ((Long)map.get("height")).intValue());
    }

    public String getValueOfCssProperty(String property) {
        return (String)this.driver.executeAtom(AndroidAtoms.GET_VALUE_OF_CSS_PROPERTY.getValue(), this, property);
    }

    public void hover() {
        throw new UnsupportedOperationException("Android does not support hover event");
    }

    public boolean isDisplayed() {
        return (Boolean)this.driver.executeAtom(AndroidAtoms.IS_DISPLAYED.getValue(), this);
    }

    private String rgbToHex(String value) {
        if ("rgba(0, 0, 0, 0)".equals(value)) {
            return "transparent";
        }
        Pattern rgb = Pattern.compile("rgb\\((\\d{1,3}),\\s(\\d{1,3}),\\s(\\d{1,3})\\)");
        Matcher matcher = rgb.matcher(value);
        if (matcher.find()) {
            String hex = "#";
            for (int i = 1; i <= 3; ++i) {
                int colour = Integer.parseInt(matcher.group(i));
                String s = Integer.toHexString(colour);
                if (s.length() == 1) {
                    s = "0" + s;
                }
                hex = hex + s;
            }
            hex = hex.toLowerCase();
            return hex;
        }
        return value;
    }

    public WebDriver getWrappedDriver() {
        return this.driver;
    }

    public String getCssValue(String propertyName) {
        throw new UnsupportedOperationException("Getting CSS values is not supported yet.");
    }

    public Coordinates getCoordinates() {
        if (this.coordinates == null) {
            this.coordinates = new AndroidCoordinates(this.elementId, this.elementId.equals("0") ? new Point(0, 0) : this.getCenterCoordinates());
        }
        return this.coordinates;
    }

    public Point getLocationOnScreenOnceScrolledIntoView() {
        return this.getLocation();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FindByImpl
    implements SearchContext,
    FindsById,
    FindsByLinkText,
    FindsByXPath,
    FindsByTagName,
    FindsByCssSelector,
    FindsByClassName {
        FindByImpl() {
        }

        public WebElement findElement(By by) {
            return by.findElement((SearchContext)AndroidWebElement.this.findsBy);
        }

        public List<WebElement> findElements(By by) {
            return by.findElements((SearchContext)AndroidWebElement.this.findsBy);
        }

        public WebElement findElementById(String using) {
            return AndroidWebElement.this.lookupElement(AndroidWebElement.LOCATOR_ID, using);
        }

        public List<WebElement> findElementsById(String using) {
            return AndroidWebElement.this.lookupElements(AndroidWebElement.LOCATOR_ID, using);
        }

        public WebElement findElementByXPath(String using) {
            return AndroidWebElement.this.lookupElement(AndroidWebElement.LOCATOR_XPATH, using);
        }

        public List<WebElement> findElementsByXPath(String using) {
            return AndroidWebElement.this.lookupElements(AndroidWebElement.LOCATOR_XPATH, using);
        }

        public WebElement findElementByLinkText(String using) {
            return AndroidWebElement.this.lookupElement(AndroidWebElement.LOCATOR_LINK_TEXT, using);
        }

        public List<WebElement> findElementsByLinkText(String using) {
            return AndroidWebElement.this.lookupElements(AndroidWebElement.LOCATOR_LINK_TEXT, using);
        }

        public WebElement findElementByPartialLinkText(String using) {
            return AndroidWebElement.this.lookupElement(AndroidWebElement.LOCATOR_PARTIAL_LINK_TEXT, using);
        }

        public List<WebElement> findElementsByPartialLinkText(String using) {
            return AndroidWebElement.this.lookupElements(AndroidWebElement.LOCATOR_PARTIAL_LINK_TEXT, using);
        }

        public WebElement findElementByTagName(String using) {
            return AndroidWebElement.this.lookupElement(AndroidWebElement.LOCATOR_TAG_NAME, using);
        }

        public List<WebElement> findElementsByTagName(String using) {
            return AndroidWebElement.this.lookupElements(AndroidWebElement.LOCATOR_TAG_NAME, using);
        }

        public WebElement findElementByName(String using) {
            return AndroidWebElement.this.lookupElement(AndroidWebElement.LOCATOR_NAME, using);
        }

        public List<WebElement> findElementsByName(String using) {
            return AndroidWebElement.this.lookupElements(AndroidWebElement.LOCATOR_NAME, using);
        }

        public WebElement findElementByCssSelector(String using) {
            return AndroidWebElement.this.lookupElement(AndroidWebElement.LOCATOR_CSS_SELECTOR, using);
        }

        public List<WebElement> findElementsByCssSelector(String using) {
            return AndroidWebElement.this.lookupElements(AndroidWebElement.LOCATOR_CSS_SELECTOR, using);
        }

        public WebElement findElementByClassName(String using) {
            return AndroidWebElement.this.lookupElement(AndroidWebElement.LOCATOR_CLASS_NAME, using);
        }

        public List<WebElement> findElementsByClassName(String using) {
            return AndroidWebElement.this.lookupElements(AndroidWebElement.LOCATOR_CLASS_NAME, using);
        }
    }
}

