/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.server.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seleniumhq.jetty7.server.Request;
import org.seleniumhq.jetty7.server.Response;
import org.seleniumhq.jetty7.server.handler.HandlerWrapper;
import org.seleniumhq.jetty7.util.DateCache;
import org.seleniumhq.jetty7.util.RolloverFileOutputStream;

public class DebugHandler
extends HandlerWrapper {
    private DateCache _date = new DateCache("HH:mm:ss", Locale.US);
    private OutputStream _out;
    private PrintStream _print;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int ms3;
        String d3;
        String ex;
        String name;
        Response base_response;
        block13: {
            base_response = baseRequest.getResponse();
            Thread thread = Thread.currentThread();
            String old_name = thread.getName();
            boolean suspend = false;
            boolean retry = false;
            name = (String)request.getAttribute("org.seleniumhq.jetty7.thread.name");
            if (name == null) {
                name = old_name + ":" + baseRequest.getScheme() + "://" + baseRequest.getLocalAddr() + ":" + baseRequest.getLocalPort() + baseRequest.getUri();
            } else {
                retry = true;
            }
            ex = null;
            try {
                try {
                    String d2 = this._date.now();
                    int ms2 = this._date.lastMs();
                    if (retry) {
                        this._print.println(d2 + (ms2 > 99 ? "." : (ms2 > 9 ? ".0" : ".00")) + ms2 + ":" + name + " RETRY");
                    } else {
                        this._print.println(d2 + (ms2 > 99 ? "." : (ms2 > 9 ? ".0" : ".00")) + ms2 + ":" + name + " " + baseRequest.getRemoteAddr() + " " + request.getMethod() + " " + baseRequest.getHeader("Cookie") + "; " + baseRequest.getHeader("User-Agent"));
                    }
                    thread.setName(name);
                    this.getHandler().handle(target, baseRequest, request, response);
                }
                catch (IOException ioe) {
                    ex = ioe.toString();
                    throw ioe;
                }
                catch (ServletException se) {
                    ex = se.toString() + ":" + se.getCause();
                    throw se;
                }
                catch (RuntimeException rte) {
                    ex = rte.toString();
                    throw rte;
                }
                catch (Error e) {
                    ex = e.toString();
                    throw e;
                }
                Object var15_18 = null;
                thread.setName(old_name);
                d3 = this._date.now();
                ms3 = this._date.lastMs();
                suspend = baseRequest.getAsyncContinuation().isSuspended();
                if (!suspend) break block13;
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                thread.setName(old_name);
                String d3 = this._date.now();
                int ms3 = this._date.lastMs();
                suspend = baseRequest.getAsyncContinuation().isSuspended();
                if (suspend) {
                    request.setAttribute("org.seleniumhq.jetty7.thread.name", (Object)name);
                    this._print.println(d3 + (ms3 > 99 ? "." : (ms3 > 9 ? ".0" : ".00")) + ms3 + ":" + name + " SUSPEND");
                    throw throwable;
                }
                this._print.println(d3 + (ms3 > 99 ? "." : (ms3 > 9 ? ".0" : ".00")) + ms3 + ":" + name + " " + base_response.getStatus() + (ex == null ? "" : "/" + ex) + " " + base_response.getContentType() + " " + base_response.getContentCount());
                throw throwable;
            }
            request.setAttribute("org.seleniumhq.jetty7.thread.name", (Object)name);
            this._print.println(d3 + (ms3 > 99 ? "." : (ms3 > 9 ? ".0" : ".00")) + ms3 + ":" + name + " SUSPEND");
            return;
        }
        this._print.println(d3 + (ms3 > 99 ? "." : (ms3 > 9 ? ".0" : ".00")) + ms3 + ":" + name + " " + base_response.getStatus() + (ex == null ? "" : "/" + ex) + " " + base_response.getContentType() + " " + base_response.getContentCount());
    }

    protected void doStart() throws Exception {
        if (this._out == null) {
            this._out = new RolloverFileOutputStream("./logs/yyyy_mm_dd.debug.log", true);
        }
        this._print = new PrintStream(this._out);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._print.close();
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public void setOutputStream(OutputStream out) {
        this._out = out;
    }
}

