/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.htmlunit.WebClient;
import org.openqa.selenium.WebDriver;

public class HtmlUnitTimeouts
implements WebDriver.Timeouts {
    private long implicitWait_ = 0L;
    private long scriptTimeout_ = 0L;
    private long pageLoadTimeout_ = 0L;
    private WebClient webClient_ = null;

    public HtmlUnitTimeouts() {
    }

    public HtmlUnitTimeouts(WebClient webClient) {
        this.webClient_ = webClient;
    }

    public Duration getImplicitWaitTimeout() {
        return Duration.ofMillis(this.implicitWait_);
    }

    @Deprecated
    public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
        this.implicitlyWait(Duration.ofMillis(TimeUnit.MILLISECONDS.convert(time, unit)));
        return this;
    }

    public WebDriver.Timeouts implicitlyWait(Duration duration) {
        this.implicitWait_ = Math.max(0L, duration.toMillis());
        return this;
    }

    public WebDriver.Timeouts scriptTimeout(Duration duration) {
        this.scriptTimeout_ = duration.toMillis();
        return this;
    }

    @Deprecated
    public WebDriver.Timeouts setScriptTimeout(long time, TimeUnit unit) {
        this.scriptTimeout(Duration.ofMillis(TimeUnit.MILLISECONDS.convert(time, unit)));
        return this;
    }

    public Duration getScriptTimeout() {
        return Duration.ofMillis(this.scriptTimeout_);
    }

    @Deprecated
    public WebDriver.Timeouts pageLoadTimeout(long time, TimeUnit unit) {
        this.pageLoadTimeout(Duration.ofMillis(TimeUnit.MILLISECONDS.convert(time, unit)));
        return this;
    }

    public WebDriver.Timeouts pageLoadTimeout(Duration duration) {
        this.pageLoadTimeout_ = duration.toMillis();
        HtmlUnitTimeouts.setPageLoadTimeoutForWebClient(this.webClient_, this.pageLoadTimeout_);
        return this;
    }

    public Duration getPageLoadTimeout() {
        return Duration.ofMillis(this.pageLoadTimeout_);
    }

    private static void setPageLoadTimeoutForWebClient(WebClient webClient, long timeout) {
        if (webClient != null) {
            webClient.getOptions().setTimeout(Math.max((int)timeout, 0));
        }
    }
}

