/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap.httpd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.AnnotatedConfig;
import org.openqa.selenium.grid.config.CompoundConfig;
import org.openqa.selenium.grid.config.ConcatenatingConfig;
import org.openqa.selenium.grid.config.EnvConfig;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.server.BaseServer;
import org.openqa.selenium.grid.server.BaseServerFlags;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusConfig;
import org.openqa.selenium.grid.server.EventBusFlags;
import org.openqa.selenium.grid.server.HelpFlags;
import org.openqa.selenium.grid.server.W3CCommandHandler;
import org.openqa.selenium.grid.sessionmap.httpd.DefaultSessionMapConfig;
import org.openqa.selenium.grid.sessionmap.local.LocalSessionMap;
import org.openqa.selenium.grid.web.Route;
import org.openqa.selenium.grid.web.Routes;
import org.openqa.selenium.remote.tracing.DistributedTracer;
import org.openqa.selenium.remote.tracing.GlobalDistributedTracer;

public class SessionMapServer
implements CliCommand {
    @Override
    public String getName() {
        return "sessions";
    }

    @Override
    public String getDescription() {
        return "Adds this server as the session map in a selenium grid.";
    }

    @Override
    public CliCommand.Executable configure(String ... args) {
        HelpFlags help = new HelpFlags();
        BaseServerFlags serverFlags = new BaseServerFlags(5556);
        EventBusFlags eventBusFlags = new EventBusFlags();
        JCommander commander = JCommander.newBuilder().programName(this.getName()).addObject((Object)help).addObject((Object)serverFlags).addObject((Object)eventBusFlags).build();
        return () -> {
            try {
                commander.parse(args);
            }
            catch (ParameterException e) {
                System.err.println(e.getMessage());
                commander.usage();
                return;
            }
            if (help.displayHelp(commander, System.out)) {
                return;
            }
            CompoundConfig config = new CompoundConfig(new EnvConfig(), new ConcatenatingConfig("sessions", '.', System.getProperties()), new AnnotatedConfig(help), new AnnotatedConfig(serverFlags), new AnnotatedConfig(eventBusFlags), new DefaultSessionMapConfig());
            LoggingOptions loggingOptions = new LoggingOptions(config);
            loggingOptions.configureLogging();
            DistributedTracer tracer = loggingOptions.getTracer();
            GlobalDistributedTracer.setInstance((DistributedTracer)tracer);
            EventBusConfig events = new EventBusConfig(config);
            EventBus bus = events.getEventBus();
            LocalSessionMap sessions = new LocalSessionMap(tracer, bus);
            BaseServerOptions serverOptions = new BaseServerOptions(config);
            BaseServer server = new BaseServer(serverOptions);
            server.addRoute((Route<?>)Routes.matching(sessions).using(sessions).decorateWith(W3CCommandHandler::new));
            server.start();
        };
    }
}

