/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Predicate;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.sessionmap.AddToSessionMap;
import org.openqa.selenium.grid.sessionmap.GetFromSessionMap;
import org.openqa.selenium.grid.sessionmap.RemoveFromSession;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.HandlerNotFoundException;
import org.openqa.selenium.grid.web.Routes;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public abstract class SessionMap
implements Predicate<HttpRequest>,
CommandHandler {
    private final Routes routes;

    public abstract boolean add(Session var1);

    public abstract Session get(SessionId var1) throws NoSuchSessionException;

    public abstract void remove(SessionId var1);

    public SessionMap() {
        Json json = new Json();
        this.routes = Routes.combine(Routes.post("/se/grid/session").using(() -> new AddToSessionMap(json, this)), Routes.get("/se/grid/session/{sessionId}").using(params -> new GetFromSessionMap(json, this, new SessionId((String)params.get("sessionId")))), Routes.delete("/se/grid/session/{sessionId}").using(params -> new RemoveFromSession(this, new SessionId((String)params.get("sessionId"))))).build();
    }

    @Override
    public boolean test(HttpRequest req) {
        return this.routes.match(req).isPresent();
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        Optional<CommandHandler> handler = this.routes.match(req);
        if (!handler.isPresent()) {
            throw new HandlerNotFoundException(req);
        }
        handler.get().execute(req, resp);
    }
}

