/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Predicate;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.router.GridStatusHandler;
import org.openqa.selenium.grid.router.HandleSession;
import org.openqa.selenium.grid.server.W3CCommandHandler;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.HandlerNotFoundException;
import org.openqa.selenium.grid.web.Route;
import org.openqa.selenium.grid.web.Routes;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.DistributedTracer;

public class Router
implements Predicate<HttpRequest>,
CommandHandler {
    private final Routes routes;

    public Router(DistributedTracer tracer, HttpClient.Factory clientFactory, SessionMap sessions, Distributor distributor) {
        this.routes = Routes.combine(Routes.get("/status").using(() -> new GridStatusHandler(new Json(), clientFactory, distributor)).decorateWith(W3CCommandHandler::new), new Route[]{Routes.matching(sessions).using(sessions), Routes.matching(distributor).using(distributor), Routes.matching(req -> req.getUri().startsWith("/session/")).using(() -> new HandleSession(tracer, clientFactory, sessions))}).build();
    }

    @Override
    public boolean test(HttpRequest req) {
        return this.routes.match(req).isPresent();
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        Optional<CommandHandler> handler = this.routes.match(req);
        if (!handler.isPresent()) {
            throw new HandlerNotFoundException(req);
        }
        handler.get().execute(req, resp);
    }
}

