/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.config;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.node.ActiveSession;
import org.openqa.selenium.grid.node.ProtocolConvertingSession;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.service.DriverService;

public class DriverServiceSessionFactory
implements SessionFactory {
    private final HttpClient.Factory clientFactory;
    private final Predicate<Capabilities> predicate;
    private final DriverService.Builder builder;

    public DriverServiceSessionFactory(HttpClient.Factory clientFactory, Predicate<Capabilities> predicate, DriverService.Builder builder) {
        this.clientFactory = Objects.requireNonNull(clientFactory);
        this.predicate = Objects.requireNonNull(predicate);
        this.builder = Objects.requireNonNull(builder);
    }

    @Override
    public boolean test(Capabilities capabilities) {
        return this.predicate.test(capabilities);
    }

    @Override
    public Optional<ActiveSession> apply(CreateSessionRequest sessionRequest) {
        if (sessionRequest.getDownstreamDialects().isEmpty()) {
            return Optional.empty();
        }
        DriverService service = this.builder.build();
        try {
            service.start();
            HttpClient client = this.clientFactory.createClient(service.getUrl());
            Command command = new Command(null, DriverCommand.NEW_SESSION((Capabilities)sessionRequest.getCapabilities()));
            ProtocolHandshake.Result result = new ProtocolHandshake().createSession(client, command);
            Set<Dialect> downstreamDialects = sessionRequest.getDownstreamDialects();
            Dialect upstream = result.getDialect();
            Dialect downstream = downstreamDialects.contains(result.getDialect()) ? result.getDialect() : downstreamDialects.iterator().next();
            Response response = result.createResponse();
            return Optional.of(new ProtocolConvertingSession(client, new SessionId(response.getSessionId()), service.getUrl(), downstream, upstream, (Capabilities)new ImmutableCapabilities((Map)response.getValue())){

                @Override
                public void stop() {
                }
            });
        }
        catch (Exception e) {
            service.stop();
            return Optional.empty();
        }
    }
}

