/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.remote;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.web.Values;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.DistributedTracer;

public class RemoteDistributor
extends Distributor {
    public static final Json JSON = new Json();
    private final Function<HttpRequest, HttpResponse> client;

    public RemoteDistributor(DistributedTracer tracer, HttpClient.Factory factory, URL url) {
        super(tracer, factory);
        Objects.requireNonNull(factory);
        Objects.requireNonNull(url);
        HttpClient client = factory.createClient(url);
        this.client = req -> {
            try {
                return client.execute(req);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    @Override
    public CreateSessionResponse newSession(HttpRequest request) throws SessionNotCreatedException {
        HttpRequest upstream = new HttpRequest(HttpMethod.POST, "/se/grid/distributor/session");
        upstream.setContent(request.getContent());
        HttpResponse response = this.client.apply(upstream);
        return (CreateSessionResponse)Values.get(response, CreateSessionResponse.class);
    }

    @Override
    public RemoteDistributor add(Node node) {
        HttpRequest request = new HttpRequest(HttpMethod.POST, "/se/grid/distributor/node");
        request.setContent(Contents.utf8String((CharSequence)JSON.toJson((Object)node.getStatus())));
        HttpResponse response = this.client.apply(request);
        Values.get(response, Void.class);
        return this;
    }

    @Override
    public void remove(UUID nodeId) {
        Objects.requireNonNull(nodeId, "Node ID must be set");
        HttpRequest request = new HttpRequest(HttpMethod.DELETE, "/se/grid/distributor/node/" + nodeId);
        HttpResponse response = this.client.apply(request);
        Values.get(response, Void.class);
    }

    @Override
    public DistributorStatus getStatus() {
        HttpRequest request = new HttpRequest(HttpMethod.GET, "/se/grid/distributor/status");
        HttpResponse response = this.client.apply(request);
        return (DistributorStatus)Values.get(response, DistributorStatus.class);
    }
}

