/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.commands.DefaultStandaloneConfig;
import org.openqa.selenium.grid.commands.StandaloneFlags;
import org.openqa.selenium.grid.config.AnnotatedConfig;
import org.openqa.selenium.grid.config.CompoundConfig;
import org.openqa.selenium.grid.config.ConcatenatingConfig;
import org.openqa.selenium.grid.config.EnvConfig;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.distributor.local.LocalDistributor;
import org.openqa.selenium.grid.docker.DockerFlags;
import org.openqa.selenium.grid.docker.DockerOptions;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.node.config.NodeOptions;
import org.openqa.selenium.grid.node.local.LocalNode;
import org.openqa.selenium.grid.router.Router;
import org.openqa.selenium.grid.server.BaseServer;
import org.openqa.selenium.grid.server.BaseServerFlags;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusConfig;
import org.openqa.selenium.grid.server.EventBusFlags;
import org.openqa.selenium.grid.server.HelpFlags;
import org.openqa.selenium.grid.server.W3CCommandHandler;
import org.openqa.selenium.grid.sessionmap.local.LocalSessionMap;
import org.openqa.selenium.grid.web.CombinedHandler;
import org.openqa.selenium.grid.web.RoutableHttpClientFactory;
import org.openqa.selenium.grid.web.Route;
import org.openqa.selenium.grid.web.Routes;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.tracing.DistributedTracer;
import org.openqa.selenium.remote.tracing.GlobalDistributedTracer;

public class Standalone
implements CliCommand {
    public static final Logger LOG = Logger.getLogger("selenium");

    @Override
    public String getName() {
        return "standalone";
    }

    @Override
    public String getDescription() {
        return "The selenium server, running everything in-process.";
    }

    @Override
    public CliCommand.Executable configure(String ... args) {
        HelpFlags help = new HelpFlags();
        BaseServerFlags baseFlags = new BaseServerFlags(4444);
        EventBusFlags eventFlags = new EventBusFlags();
        DockerFlags dockerFlags = new DockerFlags();
        StandaloneFlags standaloneFlags = new StandaloneFlags();
        JCommander commander = JCommander.newBuilder().programName("standalone").addObject((Object)baseFlags).addObject((Object)help).addObject((Object)eventFlags).addObject((Object)dockerFlags).addObject((Object)standaloneFlags).build();
        return () -> {
            String hostName;
            try {
                commander.parse(args);
            }
            catch (ParameterException e) {
                System.err.println(e.getMessage());
                commander.usage();
                return;
            }
            if (help.displayHelp(commander, System.out)) {
                return;
            }
            CompoundConfig config = new CompoundConfig(new EnvConfig(), new ConcatenatingConfig("selenium", '.', System.getProperties()), new AnnotatedConfig(help), new AnnotatedConfig(baseFlags), new AnnotatedConfig(dockerFlags), new AnnotatedConfig(standaloneFlags), new AnnotatedConfig(eventFlags), new DefaultStandaloneConfig());
            LoggingOptions loggingOptions = new LoggingOptions(config);
            loggingOptions.configureLogging();
            LOG.info("Logging configured.");
            DistributedTracer tracer = loggingOptions.getTracer();
            LOG.info("Using tracer: " + tracer);
            GlobalDistributedTracer.setInstance((DistributedTracer)tracer);
            EventBusConfig events = new EventBusConfig(config);
            EventBus bus = events.getEventBus();
            try {
                hostName = new NetworkUtils().getNonLoopbackAddressOfThisMachine();
            }
            catch (WebDriverException e) {
                hostName = "localhost";
            }
            int port = config.getInt("server", "port").orElseThrow(() -> new IllegalArgumentException("No port to use configured"));
            URI localhost = null;
            try {
                localhost = new URI("http", null, hostName, port, null, null, null);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            CombinedHandler combinedHandler = new CombinedHandler();
            RoutableHttpClientFactory clientFactory = new RoutableHttpClientFactory(localhost.toURL(), combinedHandler, HttpClient.Factory.createDefault());
            LocalSessionMap sessions = new LocalSessionMap(tracer, bus);
            combinedHandler.addHandler(sessions);
            LocalDistributor distributor = new LocalDistributor(tracer, bus, clientFactory, sessions);
            combinedHandler.addHandler(distributor);
            Router router = new Router(tracer, clientFactory, sessions, distributor);
            LocalNode.Builder nodeBuilder = LocalNode.builder(tracer, bus, clientFactory, localhost).maximumConcurrentSessions(Runtime.getRuntime().availableProcessors() * 3);
            new NodeOptions(config).configure(clientFactory, nodeBuilder);
            new DockerOptions(config).configure(clientFactory, nodeBuilder);
            LocalNode node = nodeBuilder.build();
            combinedHandler.addHandler(node);
            ((Distributor)distributor).add(node);
            BaseServer server = new BaseServer(new BaseServerOptions(config));
            server.addRoute((Route<?>)Routes.matching(router).using(router).decorateWith(W3CCommandHandler::new));
            server.start();
        };
    }
}

