/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.commands.DefaultHubConfig;
import org.openqa.selenium.grid.config.AnnotatedConfig;
import org.openqa.selenium.grid.config.CompoundConfig;
import org.openqa.selenium.grid.config.ConcatenatingConfig;
import org.openqa.selenium.grid.config.EnvConfig;
import org.openqa.selenium.grid.distributor.local.LocalDistributor;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.router.Router;
import org.openqa.selenium.grid.server.BaseServer;
import org.openqa.selenium.grid.server.BaseServerFlags;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusConfig;
import org.openqa.selenium.grid.server.EventBusFlags;
import org.openqa.selenium.grid.server.HelpFlags;
import org.openqa.selenium.grid.server.W3CCommandHandler;
import org.openqa.selenium.grid.sessionmap.local.LocalSessionMap;
import org.openqa.selenium.grid.web.CombinedHandler;
import org.openqa.selenium.grid.web.RoutableHttpClientFactory;
import org.openqa.selenium.grid.web.Route;
import org.openqa.selenium.grid.web.Routes;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.tracing.DistributedTracer;
import org.openqa.selenium.remote.tracing.GlobalDistributedTracer;

public class Hub
implements CliCommand {
    @Override
    public String getName() {
        return "hub";
    }

    @Override
    public String getDescription() {
        return "A grid hub, composed of sessions, distributor, and router.";
    }

    @Override
    public CliCommand.Executable configure(String ... args) {
        HelpFlags help = new HelpFlags();
        BaseServerFlags baseFlags = new BaseServerFlags(4444);
        EventBusFlags eventBusFlags = new EventBusFlags();
        JCommander commander = JCommander.newBuilder().programName("standalone").addObject((Object)baseFlags).addObject((Object)eventBusFlags).addObject((Object)help).build();
        return () -> {
            try {
                commander.parse(args);
            }
            catch (ParameterException e) {
                System.err.println(e.getMessage());
                commander.usage();
                return;
            }
            if (help.displayHelp(commander, System.out)) {
                return;
            }
            CompoundConfig config = new CompoundConfig(new EnvConfig(), new ConcatenatingConfig("selenium", '.', System.getProperties()), new AnnotatedConfig(help), new AnnotatedConfig(eventBusFlags), new AnnotatedConfig(baseFlags), new DefaultHubConfig());
            LoggingOptions loggingOptions = new LoggingOptions(config);
            loggingOptions.configureLogging();
            DistributedTracer tracer = loggingOptions.getTracer();
            GlobalDistributedTracer.setInstance((DistributedTracer)tracer);
            EventBusConfig events = new EventBusConfig(config);
            EventBus bus = events.getEventBus();
            CombinedHandler handler = new CombinedHandler();
            LocalSessionMap sessions = new LocalSessionMap(tracer, bus);
            handler.addHandler(sessions);
            BaseServerOptions serverOptions = new BaseServerOptions(config);
            RoutableHttpClientFactory clientFactory = new RoutableHttpClientFactory(serverOptions.getExternalUri().toURL(), handler, HttpClient.Factory.createDefault());
            LocalDistributor distributor = new LocalDistributor(tracer, bus, clientFactory, sessions);
            handler.addHandler(distributor);
            Router router = new Router(tracer, clientFactory, sessions, distributor);
            BaseServer server = new BaseServer(serverOptions);
            server.addRoute((Route<?>)Routes.matching(router).using(router).decorateWith(W3CCommandHandler::new));
            server.start();
        };
    }
}

