/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.regex.Pattern;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.seleniumhq.selenium.fluent.Internal;
import org.seleniumhq.selenium.fluent.Monitor;
import org.seleniumhq.selenium.fluent.Period;
import org.seleniumhq.selenium.fluent.internal.Context;
import org.seleniumhq.selenium.fluent.internal.Execution;

public class TestableString
extends Internal.BaseTestableObject<String> {
    public static StringChanger trimmer() {
        return new StringChanger(){

            @Override
            public String chg(String text) {
                return text.trim();
            }
        };
    }

    public static StringChanger multiSpaceEliminator() {
        return new StringChanger(){

            @Override
            public String chg(String text) {
                StringBuilder sb = new StringBuilder(text.replaceAll("\t", " "));
                int ix = sb.indexOf("  ");
                while (ix >= 0) {
                    sb.replace(ix, ix + 2, " ");
                    ix = sb.indexOf("  ");
                }
                return sb.toString();
            }
        };
    }

    public static StringChanger multiCREliminator() {
        return new StringChanger(){

            @Override
            public String chg(String text) {
                StringBuilder sb = new StringBuilder(text.replaceAll("\t", " "));
                int ix = sb.indexOf("\n\n");
                while (ix >= 0) {
                    sb.replace(ix, ix + 2, "\n");
                    ix = sb.indexOf("\n\n");
                }
                return sb.toString();
            }
        };
    }

    public static StringChanger tabsToSpaces() {
        return new StringChanger(){

            @Override
            public String chg(String text) {
                return text.replaceAll("\t", " ");
            }
        };
    }

    public static StringChanger crToChars(final String chars) {
        return new StringChanger(){

            @Override
            public String chg(String text) {
                return text.replaceAll("\n", chars);
            }
        };
    }

    public static Concatenator delimitWithChars(String charToDelimitWith) {
        return new DelimitWithChars(charToDelimitWith);
    }

    public TestableString(Execution<String> execution, Context ctx, Monitor monitor) {
        this((Period)null, execution, ctx, monitor);
    }

    private TestableString(Period within, Execution<String> execution, Context ctx, Monitor monitor) {
        super(within, execution, ctx, monitor);
    }

    public TestableString shouldBe(String shouldBe) {
        this.baseShouldBe(shouldBe);
        return this;
    }

    public TestableString within(Period period) {
        Context ctx = Context.singular(this.context, "within", null, period);
        return new TestableString(period, this.execution, ctx, this.monitor);
    }

    public TestableString shouldNotBe(String shouldNotBe) {
        this.baseShouldNotBe(shouldNotBe);
        return this;
    }

    public TestableString shouldContain(String shouldContain) {
        this.validateWrapRethrow(new ShouldContainValidation(shouldContain), Context.singular(this.context, "shouldContain", null, shouldContain));
        return this;
    }

    public TestableString shouldNotContain(String shouldNotContain) {
        this.validateWrapRethrow(new ShouldNotContainValidation(shouldNotContain), Context.singular(this.context, "shouldNotContain", null, shouldNotContain));
        return this;
    }

    public String toString() {
        this.validateWrapRethrow(new ToStringValidation(), Context.singular(this.context, "toString", null, ""));
        return (String)this.is;
    }

    public TestableString shouldMatch(String regex) {
        this.validateWrapRethrow(new ShouldMatchValidation(new MatchesRegex(regex)), Context.singular(this.context, "shouldMatch", null, regex));
        return this;
    }

    public TestableString shouldNotMatch(String regex) {
        this.validateWrapRethrow(new ShouldNotMatchValidation(new MatchesRegex(regex)), Context.singular(this.context, "shouldNotMatch", null, regex));
        return this;
    }

    public TestableString shouldMatch(Matcher<String> hamcrestMatcher) {
        this.validateWrapRethrow(new ShouldHamcrestMatchValidation(hamcrestMatcher), Context.singular(this.context, "shouldMatch", null, hamcrestMatcher));
        return this;
    }

    public TestableString shouldNotMatch(Matcher<String> hamcrestMatcher) {
        this.validateWrapRethrow(new ShouldNotHamcrestMatchValidation(hamcrestMatcher), Context.singular(this.context, "shouldNotMatch", null, hamcrestMatcher));
        return this;
    }

    private class ToStringValidation
    extends Internal.Validation {
        private ToStringValidation() {
        }

        @Override
        public void validate(long start) {
            if (TestableString.this.is != null) {
                return;
            }
            TestableString.this.is = TestableString.this.execution.doExecution();
        }
    }

    private class ShouldNotContainValidation
    extends Internal.Validation {
        private final String shouldNotContain;

        public ShouldNotContainValidation(String shouldNotContain) {
            this.shouldNotContain = shouldNotContain;
        }

        @Override
        public void validate(long start) {
            TestableString.this.assignValueIfNeeded();
            if (((String)TestableString.this.is).indexOf(this.shouldNotContain) > -1 && TestableString.this.within != null) {
                boolean passed;
                long endMillis = TestableString.this.calcEndMillis();
                do {
                    TestableString.this.is = TestableString.this.execution.doExecution();
                    boolean bl = passed = TestableString.this.is != null && ((String)TestableString.this.is).indexOf(this.shouldNotContain) == -1;
                } while (System.currentTimeMillis() < endMillis && !passed);
            }
            MatcherAssert.assertThat((String)TestableString.this.durationIfNotZero(start), (Object)TestableString.this.is, (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)this.shouldNotContain)));
        }
    }

    private class ShouldNotMatchValidation
    extends Internal.Validation {
        private final MatchesRegex matcher;

        public ShouldNotMatchValidation(MatchesRegex matcher) {
            this.matcher = matcher;
        }

        @Override
        public void validate(long start) {
            TestableString.this.assignValueIfNeeded();
            if (TestableString.this.is != null && this.matcher.matches(TestableString.this.is) && TestableString.this.within != null) {
                boolean passed;
                long endMillis = TestableString.this.calcEndMillis();
                do {
                    TestableString.this.is = TestableString.this.execution.doExecution();
                    boolean bl = passed = TestableString.this.is != null && !this.matcher.matches(TestableString.this.is);
                } while (System.currentTimeMillis() < endMillis && !passed);
            }
            MatcherAssert.assertThat((String)TestableString.this.durationIfNotZero(start), (Object)TestableString.this.is, (Matcher)CoreMatchers.not((Matcher)this.matcher));
        }
    }

    private class ShouldNotHamcrestMatchValidation
    extends Internal.Validation {
        private final Matcher<String> hamcrestMatcher;

        public ShouldNotHamcrestMatchValidation(Matcher<String> hamcrestMatcher) {
            this.hamcrestMatcher = hamcrestMatcher;
        }

        @Override
        public void validate(long start) {
            TestableString.this.assignValueIfNeeded();
            if (TestableString.this.is != null && this.hamcrestMatcher.matches(TestableString.this.is) && TestableString.this.within != null) {
                boolean passed;
                long endMillis = TestableString.this.calcEndMillis();
                do {
                    TestableString.this.is = TestableString.this.execution.doExecution();
                    boolean bl = passed = TestableString.this.is != null && !this.hamcrestMatcher.matches(TestableString.this.is);
                } while (System.currentTimeMillis() < endMillis && !passed);
            }
            MatcherAssert.assertThat((String)TestableString.this.durationIfNotZero(start), (Object)TestableString.this.is, (Matcher)CoreMatchers.not(this.hamcrestMatcher));
        }
    }

    private class ShouldHamcrestMatchValidation
    extends Internal.Validation {
        private final Matcher<String> hamcrestMatcher;

        public ShouldHamcrestMatchValidation(Matcher<String> hamcrestMatcher) {
            this.hamcrestMatcher = hamcrestMatcher;
        }

        @Override
        public void validate(long start) {
            TestableString.this.assignValueIfNeeded();
            if (TestableString.this.is != null && !this.hamcrestMatcher.matches(TestableString.this.is) && TestableString.this.within != null) {
                boolean passed;
                long endMillis = TestableString.this.calcEndMillis();
                do {
                    TestableString.this.is = TestableString.this.execution.doExecution();
                    boolean bl = passed = TestableString.this.is != null && this.hamcrestMatcher.matches(TestableString.this.is);
                } while (System.currentTimeMillis() < endMillis && !passed);
            }
            MatcherAssert.assertThat((String)TestableString.this.durationIfNotZero(start), (Object)TestableString.this.is, this.hamcrestMatcher);
        }
    }

    private class ShouldMatchValidation
    extends Internal.Validation {
        private final MatchesRegex matcher;

        public ShouldMatchValidation(MatchesRegex matcher) {
            this.matcher = matcher;
        }

        @Override
        public void validate(long start) {
            TestableString.this.assignValueIfNeeded();
            if (TestableString.this.is != null && !this.matcher.matches(TestableString.this.is) && TestableString.this.within != null) {
                boolean passed;
                long endMillis = TestableString.this.calcEndMillis();
                do {
                    TestableString.this.is = TestableString.this.execution.doExecution();
                    boolean bl = passed = TestableString.this.is != null && this.matcher.matches(TestableString.this.is);
                } while (System.currentTimeMillis() < endMillis && !passed);
            }
            MatcherAssert.assertThat((String)TestableString.this.durationIfNotZero(start), (Object)TestableString.this.is, (Matcher)this.matcher);
        }
    }

    private class ShouldContainValidation
    extends Internal.Validation {
        private final String shouldContain;

        public ShouldContainValidation(String shouldContain) {
            this.shouldContain = shouldContain;
        }

        @Override
        public void validate(long start) {
            TestableString.this.assignValueIfNeeded();
            if (((String)TestableString.this.is).indexOf(this.shouldContain) == -1 && TestableString.this.within != null) {
                boolean passed;
                long endMillis = TestableString.this.calcEndMillis();
                do {
                    TestableString.this.is = TestableString.this.execution.doExecution();
                    boolean bl = passed = TestableString.this.is != null && ((String)TestableString.this.is).indexOf(this.shouldContain) > -1;
                } while (System.currentTimeMillis() < endMillis && !passed);
            }
            MatcherAssert.assertThat((String)TestableString.this.durationIfNotZero(start), (Object)TestableString.this.is, (Matcher)Matchers.containsString((String)this.shouldContain));
        }
    }

    private static class MatchesRegex
    extends BaseMatcher<String> {
        private final String regex;
        private final Pattern pattern;

        public MatchesRegex(String regex) {
            this.regex = regex;
            this.pattern = Pattern.compile(regex, 8);
        }

        public void describeTo(Description description) {
            description.appendText("a string matching /" + this.regex + "/");
        }

        public final void describeMismatch(Object item, Description description) {
            description.appendText("was ").appendValue(item);
        }

        public final boolean matches(Object item) {
            return this.pattern.matcher((String)item).find();
        }
    }

    public static class DefaultConcatenator
    extends DelimitWithChars {
        public DefaultConcatenator() {
            super("");
        }
    }

    public static class DelimitWithChars
    implements Concatenator {
        private String delimChar;
        private String text = null;
        private boolean delimitNow = false;

        public DelimitWithChars(String delimChar) {
            this.delimChar = delimChar;
        }

        @Override
        public void start(String text) {
            this.text = text;
            if (!text.equals("")) {
                this.delimitNow = true;
            }
        }

        @Override
        public void concat(TestableString text) {
            this.text = this.text + (this.delimitNow ? this.delimChar : "") + text;
            this.delimitNow = true;
        }

        public String toString() {
            return this.text;
        }
    }

    public static class NoopStringChanger
    implements StringChanger {
        @Override
        public String chg(String text) {
            return text;
        }
    }

    public static interface StringChanger {
        public String chg(String var1);
    }

    public static interface Concatenator {
        public void start(String var1);

        public void concat(TestableString var1);
    }
}

