/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.consumer.filter;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import org.sdase.commons.shared.api.error.ApiException;
import org.sdase.commons.shared.tracing.ConsumerTracing;
import org.slf4j.MDC;

@Priority(value=990)
public class ConsumerTokenServerFilter
implements ContainerRequestFilter {
    private final boolean requireIdentifiedConsumer;
    private final List<Pattern> excludePatterns;

    public ConsumerTokenServerFilter(boolean requireIdentifiedConsumer, List<String> excludeRegex) {
        this.requireIdentifiedConsumer = requireIdentifiedConsumer;
        this.excludePatterns = excludeRegex == null ? Collections.emptyList() : excludeRegex.stream().map(Pattern::compile).collect(Collectors.toList());
    }

    public void filter(ContainerRequestContext requestContext) {
        if ("OPTIONS".equals(requestContext.getMethod())) {
            return;
        }
        Optional<String> consumerToken = this.extractConsumerTokenFromRequest(requestContext);
        Optional<String> consumerName = consumerToken.map(this::extractConsumerName);
        consumerToken.ifPresent(token -> this.addConsumerTokenToRequest(requestContext, (String)token));
        consumerName.ifPresent(this::addConsumerNameToMdc);
        consumerName.ifPresent(name -> this.addConsumerNameToRequest(requestContext, (String)name));
        if (this.requireIdentifiedConsumer && !consumerName.isPresent()) {
            String path = requestContext.getUriInfo().getPath();
            boolean pathExcluded = this.excludePatterns.stream().anyMatch(p -> p.matcher(path).matches());
            if (!pathExcluded) {
                throw ApiException.builder().httpCode(401).title("Consumer token is required to access this resource.").build();
            }
        }
    }

    private Optional<String> extractConsumerTokenFromRequest(ContainerRequestContext requestContext) {
        String consumerToken = requestContext.getHeaderString("Consumer-Token");
        if (consumerToken == null || consumerToken.trim().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(consumerToken);
    }

    private String extractConsumerName(String consumerToken) {
        return consumerToken;
    }

    private void addConsumerTokenToRequest(ContainerRequestContext requestContext, String consumerToken) {
        requestContext.setProperty(ConsumerTracing.TOKEN_ATTRIBUTE, (Object)consumerToken);
    }

    private void addConsumerNameToMdc(String consumerName) {
        if (MDC.getMDCAdapter() != null) {
            MDC.put((String)"Consumer-Name", (String)consumerName);
        }
    }

    private void addConsumerNameToRequest(ContainerRequestContext requestContext, String consumerName) {
        requestContext.setProperty(ConsumerTracing.NAME_ATTRIBUTE, (Object)consumerName);
    }
}

