/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.consumer;

import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.sdase.commons.server.consumer.ConsumerTokenConfig;
import org.sdase.commons.server.consumer.filter.ConsumerTokenServerFilter;

public class ConsumerTokenBundle<C extends Configuration>
implements ConfiguredBundle<C> {
    private final Function<C, ConsumerTokenConfig> consumerTokenConfigProvider;

    private ConsumerTokenBundle(Function<C, ConsumerTokenConfig> consumerTokenConfigProvider) {
        this.consumerTokenConfigProvider = consumerTokenConfigProvider;
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(C configuration, Environment environment) {
        ConsumerTokenConfig config = this.consumerTokenConfigProvider.apply(configuration);
        boolean requireIdentifiedConsumer = !config.isOptional();
        ConsumerTokenServerFilter consumerTokenServerFilter = new ConsumerTokenServerFilter(requireIdentifiedConsumer, config.getExcludePatterns());
        environment.jersey().register((Object)consumerTokenServerFilter);
    }

    public static OptionsBuilder builder() {
        return new Builder();
    }

    public static class Builder<C extends Configuration>
    implements FinalBuilder<C>,
    OptionsBuilder,
    ExcludeBuilder<C> {
        private Function<C, ConsumerTokenConfig> configProvider;
        private Boolean requireConsumerToken;
        private List<String> excludePattern = new ArrayList<String>();

        private Builder() {
        }

        private Builder(boolean requireConsumerToken, List<String> excludePattern) {
            this.requireConsumerToken = requireConsumerToken;
            this.excludePattern = excludePattern;
        }

        private Builder(ConsumerTokenConfigProvider<C> configProvider) {
            this.configProvider = configProvider;
        }

        public <T extends Configuration> FinalBuilder<T> withConfigProvider(ConsumerTokenConfigProvider<T> configProvider) {
            return new Builder<T>(configProvider);
        }

        @Override
        public FinalBuilder<Configuration> withOptionalConsumerToken() {
            return new Builder<Configuration>(false, this.excludePattern);
        }

        @Override
        public ExcludeBuilder<Configuration> withRequiredConsumerToken() {
            return new Builder<Configuration>(true, this.excludePattern);
        }

        @Override
        public FinalBuilder<C> withExcludePatterns(String ... pattern) {
            return new Builder<C>(this.requireConsumerToken, Arrays.asList(pattern));
        }

        @Override
        public ConsumerTokenBundle<C> build() {
            if (this.configProvider == null) {
                if (this.requireConsumerToken == null) {
                    throw new IllegalStateException("Missing either a config provider or an explicit config");
                }
                ConsumerTokenConfig consumerTokenConfig = new ConsumerTokenConfig();
                consumerTokenConfig.setOptional(this.requireConsumerToken == false);
                consumerTokenConfig.setExcludePatterns(this.excludePattern);
                this.configProvider = c -> consumerTokenConfig;
            }
            if (this.excludeSwaggerJson()) {
                this.configProvider = this.configProvider.andThen(this::addSwaggerConfigExclude);
            }
            if (this.excludeOpenApi()) {
                this.configProvider = this.configProvider.andThen(this::addOpenApiConfigExclude);
            }
            return new ConsumerTokenBundle(this.configProvider);
        }

        private ConsumerTokenConfig addSwaggerConfigExclude(ConsumerTokenConfig consumerTokenConfig) {
            ArrayList<String> patterns = new ArrayList<String>(consumerTokenConfig.getExcludePatterns());
            patterns.add("swagger\\.(json|yaml)");
            consumerTokenConfig.setExcludePatterns(patterns);
            return consumerTokenConfig;
        }

        private boolean excludeSwaggerJson() {
            try {
                if (this.getClass().getClassLoader().loadClass("org.sdase.commons.server.swagger.SwaggerBundle") != null) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return false;
        }

        private ConsumerTokenConfig addOpenApiConfigExclude(ConsumerTokenConfig consumerTokenConfig) {
            ArrayList<String> patterns = new ArrayList<String>(consumerTokenConfig.getExcludePatterns());
            patterns.add("openapi\\.(json|yaml)");
            consumerTokenConfig.setExcludePatterns(patterns);
            return consumerTokenConfig;
        }

        private boolean excludeOpenApi() {
            try {
                if (this.getClass().getClassLoader().loadClass("org.sdase.commons.server.openapi.OpenApiBundle") != null) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return false;
        }
    }

    public static interface FinalBuilder<C extends Configuration> {
        public ConsumerTokenBundle<C> build();
    }

    public static interface ExcludeBuilder<C extends Configuration>
    extends FinalBuilder<C> {
        public FinalBuilder<C> withExcludePatterns(String ... var1);
    }

    public static interface OptionsBuilder {
        public FinalBuilder<Configuration> withOptionalConsumerToken();

        public ExcludeBuilder<Configuration> withRequiredConsumerToken();

        public <C extends Configuration> FinalBuilder<C> withConfigProvider(ConsumerTokenConfigProvider<C> var1);
    }

    @FunctionalInterface
    public static interface ConsumerTokenConfigProvider<C extends Configuration>
    extends Function<C, ConsumerTokenConfig> {
    }
}

