/*
 * Copyright 2006-2012 The Scriptella Project Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package scriptella.configuration;


/**
 * Implemented by classes which support configuration from XML.
 *
 * @author Fyodor Kupolov
 * @version 1.0
 */
public interface XmlConfigurable {
    /**
     * Configures the class using specified XML element.
     *
     * @param element XML element.
     */
    public void configure(final XmlElement element);
}
