/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.up.provider.impl;

import org.codehaus.jackson.JsonNode;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.YahooApi;
import org.scribe.model.Token;
import org.scribe.up.profile.AttributeConverter;
import org.scribe.up.profile.JsonHelper;
import org.scribe.up.profile.UserProfile;
import org.scribe.up.profile.UserProfileHelper;
import org.scribe.up.provider.BaseOAuth10Provider;

public class YahooProvider
extends BaseOAuth10Provider {
    protected void internalInit() {
        String[] names;
        this.service = new ServiceBuilder().provider(YahooApi.class).apiKey(this.key).apiSecret(this.secret).callback(this.callbackUrl).build();
        for (String name : names = new String[]{"uri", "birthdate", "created", "familyName", "gender", "givenName", "lang", "memberSince", "nickname", "profileUrl", "timeZone", "updated", "isConnected"}) {
            this.mainAttributes.put(name, null);
        }
    }

    protected String getProfileUrl() {
        return "http://social.yahooapis.com/v1/me/guid?format=xml";
    }

    public UserProfile getUserProfile(Token accessToken) {
        String body = this.sendRequestForProfile(accessToken, this.getProfileUrl());
        if (body == null) {
            return null;
        }
        String guid = UserProfileHelper.substringBetween(body, "<value>", "</value>");
        logger.debug("guid : {}", (Object)guid);
        if (guid != null && !"".equals(guid.trim()) && (body = this.sendRequestForProfile(accessToken, "http://social.yahooapis.com/v1/user/" + guid + "/profile?format=json")) == null) {
            return null;
        }
        return this.extractUserProfile(body);
    }

    protected UserProfile extractUserProfile(String body) {
        UserProfile userProfile = new UserProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null && (json = json.get("profile")) != null) {
            UserProfileHelper.addIdentifier(userProfile, json, "guid");
            for (String attribute : this.mainAttributes.keySet()) {
                UserProfileHelper.addAttribute(userProfile, json, attribute, (AttributeConverter<? extends Object>)((AttributeConverter)this.mainAttributes.get(attribute)));
            }
        }
        return userProfile;
    }
}

