/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.up.provider.impl;

import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.LinkedInApi;
import org.scribe.up.profile.AttributeConverter;
import org.scribe.up.profile.UserProfile;
import org.scribe.up.profile.UserProfileHelper;
import org.scribe.up.provider.BaseOAuth10Provider;

public class LinkedInProvider
extends BaseOAuth10Provider {
    protected void internalInit() {
        this.service = new ServiceBuilder().provider(LinkedInApi.class).apiKey(this.key).apiSecret(this.secret).callback(this.callbackUrl).build();
        this.mainAttributes.put("first-name", null);
        this.mainAttributes.put("last-name", null);
        this.mainAttributes.put("headline", null);
        this.mainAttributes.put("url", null);
    }

    protected String getProfileUrl() {
        return "http://api.linkedin.com/v1/people/~";
    }

    protected UserProfile extractUserProfile(String body) {
        UserProfile userProfile = new UserProfile();
        for (String attribute : this.mainAttributes.keySet()) {
            String value = UserProfileHelper.substringBetween(body, "<" + attribute + ">", "</" + attribute + ">");
            UserProfileHelper.addAttribute(userProfile, attribute, (Object)value, (AttributeConverter<? extends Object>)((AttributeConverter)this.mainAttributes.get(attribute)));
            if (!"url".equals(attribute)) continue;
            String id = UserProfileHelper.substringBetween(value, "&amp;key=", "&amp;authToken=");
            UserProfileHelper.addIdentifier(userProfile, id);
        }
        return userProfile;
    }
}

