/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.up.provider.impl;

import org.codehaus.jackson.JsonNode;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.GoogleApi;
import org.scribe.model.Token;
import org.scribe.up.profile.AttributeConverter;
import org.scribe.up.profile.JsonHelper;
import org.scribe.up.profile.UserProfile;
import org.scribe.up.profile.UserProfileHelper;
import org.scribe.up.provider.BaseOAuth10Provider;
import org.scribe.up.session.UserSession;

public class GoogleProvider
extends BaseOAuth10Provider {
    protected void internalInit() {
        this.service = new ServiceBuilder().provider(GoogleApi.class).apiKey(this.key).apiSecret(this.secret).scope("http://www-opensocial.googleusercontent.com/api/people/").callback(this.callbackUrl).build();
        this.mainAttributes.put("profileUrl", null);
        this.mainAttributes.put("isViewer", null);
        this.mainAttributes.put("displayName", null);
    }

    public String getAuthorizationUrl(UserSession session) {
        Token requestToken = this.service.getRequestToken();
        logger.debug("requestToken : {}", (Object)requestToken);
        session.setAttribute(this.getType() + "#" + "requestToken", requestToken);
        String authorizationUrl = "https://www.google.com/accounts/OAuthAuthorizeToken?oauth_token=" + requestToken.getToken();
        logger.debug("authorizationUrl : {}", (Object)authorizationUrl);
        return authorizationUrl;
    }

    protected String getProfileUrl() {
        return "http://www-opensocial.googleusercontent.com/api/people/@me/@self";
    }

    protected UserProfile extractUserProfile(String body) {
        UserProfile userProfile = new UserProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null && (json = json.get("entry")) != null) {
            UserProfileHelper.addIdentifier(userProfile, json, "id");
            for (String attribute : this.mainAttributes.keySet()) {
                UserProfileHelper.addAttribute(userProfile, json, attribute, (AttributeConverter<? extends Object>)((AttributeConverter)this.mainAttributes.get(attribute)));
            }
            if ((json = json.get("name")) != null) {
                UserProfileHelper.addAttribute(userProfile, json, "formatted", null);
                UserProfileHelper.addAttribute(userProfile, json, "familyName", null);
                UserProfileHelper.addAttribute(userProfile, json, "givenName", null);
            }
        }
        return userProfile;
    }
}

