/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.up.provider.impl;

import org.codehaus.jackson.JsonNode;
import org.scribe.builder.ServiceBuilder;
import org.scribe.up.builder.api.GitHubApi;
import org.scribe.up.profile.AttributeConverter;
import org.scribe.up.profile.JsonHelper;
import org.scribe.up.profile.UserProfile;
import org.scribe.up.profile.UserProfileHelper;
import org.scribe.up.provider.BaseOAuth20Provider;

public class GitHubProvider
extends BaseOAuth20Provider {
    protected void internalInit() {
        String[] names;
        this.service = new ServiceBuilder().provider(GitHubApi.class).apiKey(this.key).apiSecret(this.secret).callback(this.callbackUrl).scope("user").build();
        for (String name : names = new String[]{"gravatar_id", "company", "name", "created_at", "location", "disk_usage", "collaborators", "public_repo_count", "public_gist_count", "blog", "following_count", "owned_private_repo_count", "private_gist_count", "type", "permission", "total_private_repo_count", "followers_count", "login", "email"}) {
            this.mainAttributes.put(name, null);
        }
    }

    protected String getProfileUrl() {
        return "https://github.com/api/v2/json/user/show";
    }

    protected UserProfile extractUserProfile(String body) {
        UserProfile userProfile = new UserProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null && (json = json.get("user")) != null) {
            UserProfileHelper.addIdentifier(userProfile, json, "id");
            for (String attribute : this.mainAttributes.keySet()) {
                UserProfileHelper.addAttribute(userProfile, json, attribute, (AttributeConverter<? extends Object>)((AttributeConverter)this.mainAttributes.get(attribute)));
            }
        }
        return userProfile;
    }
}

