/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.up.provider.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.codehaus.jackson.JsonNode;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.FacebookApi;
import org.scribe.up.profile.AttributeConverter;
import org.scribe.up.profile.DateConverter;
import org.scribe.up.profile.GenderConverter;
import org.scribe.up.profile.JsonHelper;
import org.scribe.up.profile.LocaleConverter;
import org.scribe.up.profile.UserProfile;
import org.scribe.up.profile.UserProfileHelper;
import org.scribe.up.profile.facebook.FacebookEducation;
import org.scribe.up.profile.facebook.FacebookObject;
import org.scribe.up.profile.facebook.FacebookProfileHelper;
import org.scribe.up.profile.facebook.FacebookRelationshipStatusConverter;
import org.scribe.up.profile.facebook.FacebookWork;
import org.scribe.up.provider.BaseOAuth20Provider;

public class FacebookProvider
extends BaseOAuth20Provider {
    protected void internalInit() {
        String[] names;
        this.service = this.scope != null ? new ServiceBuilder().provider(FacebookApi.class).apiKey(this.key).apiSecret(this.secret).callback(this.callbackUrl).scope(this.scope).build() : new ServiceBuilder().provider(FacebookApi.class).apiKey(this.key).apiSecret(this.secret).callback(this.callbackUrl).build();
        for (String name : names = new String[]{"name", "first_name", "middle_name", "last_name", "link", "username", "third_party_id", "timezone", "verified", "bio", "email", "political", "quotes", "religion", "website"}) {
            this.mainAttributes.put(name, null);
        }
        this.mainAttributes.put("gender", new GenderConverter("male"));
        this.mainAttributes.put("locale", new LocaleConverter());
        this.mainAttributes.put("updated_time", new DateConverter("yyyy-MM-dd'T'HH:mm:ssz"));
        this.mainAttributes.put("birthday", new DateConverter("MM/dd/yyyy"));
        this.mainAttributes.put("relationship_status", new FacebookRelationshipStatusConverter());
    }

    protected String getProfileUrl() {
        return "https://graph.facebook.com/me";
    }

    protected UserProfile extractUserProfile(String body) {
        JsonNode subJson;
        UserProfile userProfile = new UserProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            UserProfileHelper.addIdentifier(userProfile, json, "id");
            for (String attribute : this.mainAttributes.keySet()) {
                UserProfileHelper.addAttribute(userProfile, json, attribute, (AttributeConverter<? extends Object>)((AttributeConverter)this.mainAttributes.get(attribute)));
            }
        }
        if ((subJson = json.get("languages")) != null) {
            UserProfileHelper.addAttribute(userProfile, "languages", FacebookProfileHelper.getListFacebookObject(subJson));
        }
        if ((subJson = json.get("education")) != null) {
            ArrayList<FacebookEducation> education = new ArrayList<FacebookEducation>();
            Iterator educationIterator = subJson.getElements();
            while (educationIterator.hasNext()) {
                JsonNode jsonEducation = (JsonNode)educationIterator.next();
                FacebookEducation oneEducation = new FacebookEducation(jsonEducation);
                education.add(oneEducation);
            }
            UserProfileHelper.addAttribute(userProfile, "education", education);
        }
        if ((subJson = json.get("hometown")) != null) {
            UserProfileHelper.addAttribute(userProfile, "hometown", new FacebookObject(subJson));
        }
        if ((subJson = json.get("interested_in")) != null) {
            Iterator interestIterator = subJson.getElements();
            ArrayList<String> interested_in = new ArrayList<String>();
            while (interestIterator.hasNext()) {
                JsonNode interest = (JsonNode)interestIterator.next();
                interested_in.add(interest.getTextValue());
            }
            UserProfileHelper.addAttribute(userProfile, "interested_in", interested_in);
        }
        if ((subJson = json.get("location")) != null) {
            UserProfileHelper.addAttribute(userProfile, "location", new FacebookObject(subJson));
        }
        if ((subJson = json.get("favorite_athletes")) != null) {
            UserProfileHelper.addAttribute(userProfile, "favorite_athletes", FacebookProfileHelper.getListFacebookObject(subJson));
        }
        if ((subJson = json.get("favorite_teams")) != null) {
            UserProfileHelper.addAttribute(userProfile, "favorite_teams", FacebookProfileHelper.getListFacebookObject(subJson));
        }
        if ((subJson = json.get("significant_other")) != null) {
            UserProfileHelper.addAttribute(userProfile, "significant_other", new FacebookObject(subJson));
        }
        if ((subJson = json.get("work")) != null) {
            ArrayList<FacebookWork> work = new ArrayList<FacebookWork>();
            Iterator workIterator = subJson.getElements();
            while (workIterator.hasNext()) {
                JsonNode jsonWork = (JsonNode)workIterator.next();
                FacebookWork oneWork = new FacebookWork(jsonWork);
                work.add(oneWork);
            }
            UserProfileHelper.addAttribute(userProfile, "work", work);
        }
        return userProfile;
    }
}

