/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.up.provider;

import java.util.HashMap;
import java.util.Map;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.oauth.OAuthService;
import org.scribe.up.credential.OAuthCredential;
import org.scribe.up.profile.AttributeConverter;
import org.scribe.up.profile.UserProfile;
import org.scribe.up.provider.OAuthProvider;
import org.scribe.up.provider.impl.GoogleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseOAuthProvider
implements OAuthProvider {
    protected static final Logger logger = LoggerFactory.getLogger(BaseOAuthProvider.class);
    protected static final String REQUEST_TOKEN = "requestToken";
    protected static final String ERROR_REASON = "error_reason";
    protected static final String ERROR_DESCRIPTION = "error_description";
    protected OAuthService service;
    protected String key;
    protected String secret;
    protected String callbackUrl;
    protected Map<String, AttributeConverter<? extends Object>> mainAttributes = new HashMap<String, AttributeConverter<? extends Object>>();
    protected String scope;
    private boolean initialized = false;

    @Override
    public synchronized void init() {
        if (!this.initialized) {
            this.internalInit();
            this.initialized = true;
        }
    }

    protected abstract void internalInit();

    @Override
    public UserProfile getUserProfile(Token accessToken) {
        String body = this.sendRequestForProfile(accessToken, this.getProfileUrl());
        if (body == null) {
            return null;
        }
        return this.extractUserProfile(body);
    }

    protected abstract String getProfileUrl();

    protected String sendRequestForProfile(Token accessToken, String profileUrl) {
        logger.debug("accessToken : {} / profileUrl : {}", (Object)accessToken, (Object)profileUrl);
        OAuthRequest request = new OAuthRequest(Verb.GET, profileUrl);
        this.service.signRequest(accessToken, request);
        if (this instanceof GoogleProvider) {
            request.addHeader("GData-Version", "3.0");
        }
        Response response = request.send();
        int code = response.getCode();
        String body = response.getBody();
        logger.debug("response code : {} / response body : {}", (Object)code, (Object)body);
        if (code != 200) {
            logger.error("Get the user profile failed, code : " + code + " / body : " + body);
            return null;
        }
        return body;
    }

    protected abstract UserProfile extractUserProfile(String var1);

    @Override
    public OAuthCredential getCredential(Map<String, String[]> parameters) {
        String[] error_reasons = parameters.get(ERROR_REASON);
        String error_reason = null;
        String[] error_descriptions = parameters.get(ERROR_DESCRIPTION);
        String error_description = null;
        if (error_reasons != null && error_reasons.length > 0) {
            error_reason = error_reasons[0];
        }
        if (error_descriptions != null && error_descriptions.length > 0) {
            error_description = error_descriptions[0];
        }
        if (error_reason != null || error_description != null) {
            logger.error("Error reason : {} / description : {}", (Object)error_reason, (Object)error_description);
            return null;
        }
        return this.extractCredentialFromParameters(parameters);
    }

    protected abstract OAuthCredential extractCredentialFromParameters(Map<String, String[]> var1);

    public void setKey(String key) {
        this.key = key;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    @Override
    public String getType() {
        return this.getClass().getSimpleName();
    }

    public String getKey() {
        return this.key;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

