/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.up.provider;

import java.util.Map;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.up.credential.OAuthCredential;
import org.scribe.up.provider.BaseOAuthProvider;
import org.scribe.up.session.UserSession;
import org.scribe.utils.OAuthEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseOAuth20Provider
extends BaseOAuthProvider {
    protected static final Logger logger = LoggerFactory.getLogger(BaseOAuth20Provider.class);
    public static final String OAUTH_CODE = "code";

    @Override
    public String getAuthorizationUrl(UserSession session) {
        String authorizationUrl = this.service.getAuthorizationUrl(null);
        logger.debug("authorizationUrl : {}", (Object)authorizationUrl);
        return authorizationUrl;
    }

    @Override
    public Token getAccessToken(UserSession session, OAuthCredential credential) {
        String verifier = credential.getVerifier();
        logger.debug("verifier : {}", (Object)verifier);
        Verifier providerVerifier = new Verifier(verifier);
        Token accessToken = this.service.getAccessToken(null, providerVerifier);
        logger.debug("accessToken : {}", (Object)accessToken);
        return accessToken;
    }

    @Override
    public OAuthCredential extractCredentialFromParameters(Map<String, String[]> parameters) {
        String[] verifiers = parameters.get(OAUTH_CODE);
        if (verifiers != null && verifiers.length == 1) {
            String verifier = OAuthEncoder.decode((String)verifiers[0]);
            logger.debug("verifier : {}", (Object)verifier);
            return new OAuthCredential(null, verifier, this.getType());
        }
        logger.error("No credential found");
        return null;
    }
}

