/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.up.provider;

import java.util.Map;
import org.scribe.exceptions.OAuthException;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.up.credential.OAuthCredential;
import org.scribe.up.provider.BaseOAuthProvider;
import org.scribe.up.session.UserSession;
import org.scribe.utils.OAuthEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseOAuth10Provider
extends BaseOAuthProvider {
    protected static final Logger logger = LoggerFactory.getLogger(BaseOAuth10Provider.class);
    public static final String OAUTH_TOKEN = "oauth_token";
    public static final String OAUTH_VERIFIER = "oauth_verifier";

    @Override
    public String getAuthorizationUrl(UserSession session) {
        Token requestToken = this.service.getRequestToken();
        logger.debug("requestToken : {}", (Object)requestToken);
        session.setAttribute(this.getType() + "#" + "requestToken", requestToken);
        String authorizationUrl = this.service.getAuthorizationUrl(requestToken);
        logger.debug("authorizationUrl : {}", (Object)authorizationUrl);
        return authorizationUrl;
    }

    @Override
    public Token getAccessToken(UserSession session, OAuthCredential credential) {
        String token = credential.getToken();
        String verifier = credential.getVerifier();
        logger.debug("token : {}", (Object)token);
        logger.debug("verifier : {}", (Object)verifier);
        Token tokenRequest = (Token)session.getAttribute(this.getType() + "#" + "requestToken");
        logger.debug("tokenRequest : {}", (Object)tokenRequest);
        if (tokenRequest == null) {
            throw new OAuthException("Token request expired");
        }
        String savedToken = tokenRequest.getToken();
        logger.debug("savedToken : {}", (Object)savedToken);
        if (savedToken == null || !savedToken.equals(token)) {
            throw new OAuthException("Token received : " + token + " is different from saved token : " + savedToken);
        }
        Verifier providerVerifier = new Verifier(verifier);
        Token accessToken = this.service.getAccessToken(tokenRequest, providerVerifier);
        logger.debug("accessToken : {}", (Object)accessToken);
        return accessToken;
    }

    @Override
    public OAuthCredential extractCredentialFromParameters(Map<String, String[]> parameters) {
        String[] tokens = parameters.get(OAUTH_TOKEN);
        String[] verifiers = parameters.get(OAUTH_VERIFIER);
        if (tokens != null && tokens.length == 1 && verifiers != null && verifiers.length == 1) {
            String token = OAuthEncoder.decode((String)tokens[0]);
            String verifier = OAuthEncoder.decode((String)verifiers[0]);
            logger.debug("token : {} / verifier : {}", (Object)token, (Object)verifier);
            return new OAuthCredential(token, verifier, this.getType());
        }
        logger.error("No credential found");
        return null;
    }
}

