/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.up.profile.facebook;

import java.util.Date;
import org.codehaus.jackson.JsonNode;
import org.scribe.up.profile.DateConverter;
import org.scribe.up.profile.JsonHelper;
import org.scribe.up.profile.facebook.FacebookObject;

public final class FacebookWork {
    private static DateConverter dateConverter = new DateConverter("yyyy-MM");
    private FacebookObject employer;
    private FacebookObject location;
    private FacebookObject position;
    private String description;
    private Date startDate;
    private Date endDate;

    public FacebookWork(JsonNode json) {
        if (json != null) {
            this.employer = new FacebookObject(json.get("employer"));
            this.location = new FacebookObject(json.get("location"));
            this.position = new FacebookObject(json.get("position"));
            this.description = JsonHelper.getTextValue(json, "description");
            this.startDate = dateConverter.convert(JsonHelper.getTextValue(json, "start_date"));
            this.endDate = dateConverter.convert(JsonHelper.getTextValue(json, "end_date"));
        }
    }

    public FacebookObject getEmployer() {
        return this.employer;
    }

    public FacebookObject getLocation() {
        return this.location;
    }

    public FacebookObject getPosition() {
        return this.position;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String toString() {
        return "FacebookWork[employer:" + this.employer + ",location:" + this.location + ",position:" + this.position + ",description:" + this.description + ",start_date:" + this.startDate + ",end_date:" + this.endDate + "]";
    }
}

