/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.up.profile.facebook;

import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.scribe.up.profile.JsonHelper;
import org.scribe.up.profile.facebook.FacebookObject;
import org.scribe.up.profile.facebook.FacebookProfileHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacebookEducation {
    private FacebookObject school;
    private FacebookObject degree;
    private FacebookObject year;
    private List<FacebookObject> concentration;
    private String type;

    public FacebookEducation(JsonNode json) {
        if (json != null) {
            this.school = new FacebookObject(json.get("school"));
            this.degree = new FacebookObject(json.get("degree"));
            this.year = new FacebookObject(json.get("year"));
            JsonNode jsonConcentration = json.get("concentration");
            this.concentration = FacebookProfileHelper.getListFacebookObject(jsonConcentration);
            this.type = JsonHelper.getTextValue(json, "type");
        }
    }

    public FacebookEducation(FacebookObject school, FacebookObject degree, FacebookObject year, List<FacebookObject> concentration, String type) {
        this.school = school;
        this.degree = degree;
        this.year = year;
        this.concentration = concentration;
        this.type = type;
    }

    public FacebookObject getSchool() {
        return this.school;
    }

    public FacebookObject getDegree() {
        return this.degree;
    }

    public FacebookObject getYear() {
        return this.year;
    }

    public List<FacebookObject> getConcentration() {
        return this.concentration;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return "FacebookEducation[school:" + this.school + ",degree:" + this.degree + ",year:" + this.year + ",concentration:" + this.concentration + ",type:" + this.type + "]";
    }
}

