/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.up.profile;

import org.codehaus.jackson.JsonNode;
import org.scribe.up.profile.AttributeConverter;
import org.scribe.up.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UserProfileHelper {
    private static final Logger logger = LoggerFactory.getLogger(UserProfileHelper.class);

    private UserProfileHelper() {
    }

    public static String substringBetween(String text, String s1, String s2) {
        int end;
        int begin;
        if (text != null && s1 != null && s2 != null && (begin = text.indexOf(s1)) >= 0 && (end = text.indexOf(s2, begin)) >= 0) {
            String extract = text.substring(begin + s1.length(), end);
            logger.debug("String extracted between {} and {} in {} : {}", new Object[]{s1, s2, text, extract});
            return extract;
        }
        return null;
    }

    public static void addIdentifier(UserProfile userProfile, JsonNode json, String attributeName) {
        JsonNode id;
        String userId = null;
        if (json != null && (id = json.get(attributeName)) != null) {
            if (id.isNumber()) {
                userId = id.getNumberValue().toString();
            } else if (id.isTextual()) {
                userId = id.getTextValue();
            }
            UserProfileHelper.addIdentifier(userProfile, userId);
        }
    }

    public static void addIdentifier(UserProfile userProfile, String id) {
        logger.debug("id : {}", (Object)id);
        userProfile.setId(id);
    }

    public static void addAttribute(UserProfile userProfile, JsonNode json, String attributeName) {
        UserProfileHelper.addAttribute(userProfile, json, attributeName, null);
    }

    public static void addAttribute(UserProfile userProfile, JsonNode json, String attributeName, AttributeConverter<? extends Object> converter) {
        JsonNode value;
        if (json != null && (value = json.get(attributeName)) != null) {
            Object attribute = null;
            if (value.isNumber()) {
                attribute = value.getNumberValue();
            } else if (value.isBoolean()) {
                attribute = value.getBooleanValue();
            } else if (value.isTextual()) {
                attribute = value.getTextValue();
            }
            UserProfileHelper.addAttribute(userProfile, attributeName, attribute, converter);
        }
    }

    public static void addAttribute(UserProfile userProfile, String attributeName, Object attribute) {
        UserProfileHelper.addAttribute(userProfile, attributeName, attribute, null);
    }

    public static void addAttribute(UserProfile userProfile, String attributeName, Object attribute, AttributeConverter<? extends Object> converter) {
        if (converter != null) {
            attribute = converter.convert(attribute);
        }
        if (attribute == null) {
            logger.debug("key : {} / attribute : {}", (Object)attributeName, attribute);
        } else {
            logger.debug("key : {} / attribute : {} / {}", new Object[]{attributeName, attribute, attribute.getClass()});
        }
        userProfile.addAttribute(attributeName, attribute);
    }
}

