/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.up.profile;

import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonHelper {
    private static final Logger logger = LoggerFactory.getLogger(JsonHelper.class);
    private static ObjectMapper mapper = new ObjectMapper();

    private JsonHelper() {
    }

    public static JsonNode getFirstNode(String text) {
        try {
            return (JsonNode)mapper.readValue(text, JsonNode.class);
        }
        catch (JsonParseException e) {
            logger.error("JsonParseException", (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error("JsonMappingException", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IOException", (Throwable)e);
        }
        return null;
    }

    public static String getTextValue(JsonNode json, String name) {
        JsonNode node;
        if (json != null && (node = json.get(name)) != null) {
            return node.getTextValue();
        }
        return null;
    }
}

