/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.up.profile;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.scribe.up.profile.AttributeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DateConverter
implements AttributeConverter<Date> {
    protected static final Logger logger = LoggerFactory.getLogger(DateConverter.class);
    protected String format;

    public DateConverter() {
    }

    public DateConverter(String format) {
        this.format = format;
    }

    @Override
    public Date convert(Object attribute) {
        if (attribute != null) {
            if (attribute instanceof String && this.format != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.format);
                try {
                    return simpleDateFormat.parse((String)attribute);
                }
                catch (ParseException e) {
                    logger.error("parse exception on " + attribute + " with format : " + this.format, (Throwable)e);
                }
            } else {
                if (attribute instanceof Integer) {
                    return new Date(((Integer)attribute).intValue());
                }
                if (attribute instanceof Long) {
                    return new Date((Long)attribute);
                }
            }
        }
        return null;
    }
}

