/*
 * Decompiled with CFR 0.152.
 */
package scoverage.reporter;

import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PrettyPrinter;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;
import scoverage.domain.Coverage;
import scoverage.domain.MeasuredClass;
import scoverage.domain.MeasuredMethod;
import scoverage.domain.MeasuredPackage;
import scoverage.domain.Statement;
import scoverage.reporter.BaseReportWriter;
import scoverage.reporter.IOUtils$;

@ScalaSignature(bytes="\u0006\u0005\u0005\ra\u0001\u0002\b\u0010\u0001QA\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IA\u0007\u0005\ta\u0001\u0011\t\u0011)A\u0005Q!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u0015\u0011\u0005\u0001\"\u0001J\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u0015a\u0006\u0001\"\u0003^\u0011\u0015!\u0007\u0001\"\u0003f\u0011\u0015Y\u0007\u0001\"\u0003m\u0011\u0015\t\b\u0001\"\u0003s\u0011\u00159\b\u0001\"\u0003y\u0011\u0015i\b\u0001\"\u0001\u007f\u0005I\u00196m\u001c<fe\u0006<W\rW7m/JLG/\u001a:\u000b\u0005A\t\u0012\u0001\u0003:fa>\u0014H/\u001a:\u000b\u0003I\t\u0011b]2pm\u0016\u0014\u0018mZ3\u0004\u0001M\u0011\u0001!\u0006\t\u0003-]i\u0011aD\u0005\u00031=\u0011\u0001CQ1tKJ+\u0007o\u001c:u/JLG/\u001a:\u0002#M|WO]2f\t&\u0014Xm\u0019;pe&,7\u000fE\u0002\u001cK!r!\u0001\b\u0012\u000f\u0005u\u0001S\"\u0001\u0010\u000b\u0005}\u0019\u0012A\u0002\u001fs_>$h(C\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019C%A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\u0005J!AJ\u0014\u0003\u0007M+\u0017O\u0003\u0002$IA\u0011\u0011FL\u0007\u0002U)\u00111\u0006L\u0001\u0003S>T\u0011!L\u0001\u0005U\u00064\u0018-\u0003\u00020U\t!a)\u001b7f\u0003%yW\u000f\u001e9vi\u0012K'/A\u0003eK\n,x\r\u0005\u00024i5\tA%\u0003\u00026I\t9!i\\8mK\u0006t\u0017AD:pkJ\u001cW-\u00128d_\u0012Lgn\u001a\t\u0004gaR\u0014BA\u001d%\u0005\u0019y\u0005\u000f^5p]B\u00111h\u0010\b\u0003yu\u0002\"!\b\u0013\n\u0005y\"\u0013A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n11\u000b\u001e:j]\u001eT!A\u0010\u0013\u0002\rqJg.\u001b;?)\u0015!UIR$I!\t1\u0002\u0001C\u0003\u001a\u000b\u0001\u0007!\u0004C\u00031\u000b\u0001\u0007\u0001\u0006C\u00032\u000b\u0001\u0007!\u0007C\u00037\u000b\u0001\u0007q\u0007F\u0003E\u00152ke\nC\u0003L\r\u0001\u0007\u0001&A\u0005t_V\u00148-\u001a#je\")\u0001G\u0002a\u0001Q!)\u0011G\u0002a\u0001e!)aG\u0002a\u0001o\u0005)qO]5uKR\u0011\u0011\u000b\u0016\t\u0003gIK!a\u0015\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006+\u001e\u0001\rAV\u0001\tG>4XM]1hKB\u0011qKW\u0007\u00021*\u0011\u0011,E\u0001\u0007I>l\u0017-\u001b8\n\u0005mC&\u0001C\"pm\u0016\u0014\u0018mZ3\u0002\u0007alG\u000e\u0006\u0002_GB\u0011q,Y\u0007\u0002A*\u0011A\fJ\u0005\u0003E\u0002\u0014AAT8eK\")Q\u000b\u0003a\u0001-\u0006I1\u000f^1uK6,g\u000e\u001e\u000b\u0003=\u001aDQaZ\u0005A\u0002!\fAa\u001d;niB\u0011q+[\u0005\u0003Ub\u0013\u0011b\u0015;bi\u0016lWM\u001c;\u0002\r5,G\u000f[8e)\tqV\u000eC\u0003l\u0015\u0001\u0007a\u000e\u0005\u0002X_&\u0011\u0001\u000f\u0017\u0002\u000f\u001b\u0016\f7/\u001e:fI6+G\u000f[8e\u0003\u0015YG.Y:t)\tq6\u000fC\u0003r\u0017\u0001\u0007A\u000f\u0005\u0002Xk&\u0011a\u000f\u0017\u0002\u000e\u001b\u0016\f7/\u001e:fI\u000ec\u0017m]:\u0002\tA\f7m\u001b\u000b\u0003=fDQa\u001e\u0007A\u0002i\u0004\"aV>\n\u0005qD&aD'fCN,(/\u001a3QC\u000e\\\u0017mZ3\u0002\r\u0015\u001c8-\u00199f)\tQt\u0010\u0003\u0004\u0002\u00025\u0001\rAO\u0001\u0003S:\u0004")
public class ScoverageXmlWriter
extends BaseReportWriter {
    private final File outputDir;
    private final boolean debug;
    private final Option<String> sourceEncoding;

    public void write(Coverage coverage) {
        File file = IOUtils$.MODULE$.reportFile(this.outputDir, this.debug);
        PrettyPrinter qual$1 = new PrettyPrinter(120, 4);
        Node x$1 = this.xml(coverage);
        NamespaceBinding x$2 = qual$1.format$default$2();
        IOUtils$.MODULE$.writeToFile(file, qual$1.format(x$1, x$2), this.sourceEncoding);
    }

    /*
     * WARNING - void declaration
     */
    private Node xml(Coverage coverage) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("timestamp", Long.toString(System.currentTimeMillis()), (MetaData)$md);
        $md = new UnprefixedAttribute("version", (Seq)new Text("1.0"), (MetaData)$md);
        $md = new UnprefixedAttribute("branch-rate", coverage.branchCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-rate", coverage.statementCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statements-invoked", Integer.toString(coverage.invokedStatementCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-count", Integer.toString(coverage.statementCount()), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(coverage.packages().map((Function1 & Serializable)pack -> this.pack((MeasuredPackage)pack)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "packages", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "scoverage", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    private Node statement(Statement stmt) {
        boolean bl = this.debug;
        if (bl) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("ignored", Boolean.toString(stmt.ignored()), (MetaData)$md);
            $md = new UnprefixedAttribute("invocation-count", Integer.toString(stmt.count()), (MetaData)$md);
            $md = new UnprefixedAttribute("branch", Boolean.toString(stmt.branch()), (MetaData)$md);
            $md = new UnprefixedAttribute("tree", this.escape(stmt.treeName()), (MetaData)$md);
            $md = new UnprefixedAttribute("symbol", this.escape(stmt.symbolName()), (MetaData)$md);
            $md = new UnprefixedAttribute("line", Integer.toString(stmt.line()), (MetaData)$md);
            $md = new UnprefixedAttribute("end", Integer.toString(stmt.end()), (MetaData)$md);
            $md = new UnprefixedAttribute("start", Integer.toString(stmt.start()), (MetaData)$md);
            $md = new UnprefixedAttribute("method", stmt.location().method(), (MetaData)$md);
            $md = new UnprefixedAttribute("source", stmt.source(), (MetaData)$md);
            $md = new UnprefixedAttribute("full-class-name", stmt.location().fullClassName(), (MetaData)$md);
            $md = new UnprefixedAttribute("class-type", stmt.location().classType().toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("class", stmt.location().className(), (MetaData)$md);
            $md = new UnprefixedAttribute("package", stmt.location().packageName(), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)this.escape(stmt.desc()));
            $buf.$amp$plus((Object)new Text("\n        "));
            return new Elem(null, "statement", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        }
        if (!bl) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("ignored", Boolean.toString(stmt.ignored()), (MetaData)$md);
            $md = new UnprefixedAttribute("invocation-count", Integer.toString(stmt.count()), (MetaData)$md);
            $md = new UnprefixedAttribute("branch", Boolean.toString(stmt.branch()), (MetaData)$md);
            $md = new UnprefixedAttribute("line", Integer.toString(stmt.line()), (MetaData)$md);
            $md = new UnprefixedAttribute("end", Integer.toString(stmt.end()), (MetaData)$md);
            $md = new UnprefixedAttribute("start", Integer.toString(stmt.start()), (MetaData)$md);
            $md = new UnprefixedAttribute("method", stmt.location().method(), (MetaData)$md);
            $md = new UnprefixedAttribute("source", stmt.source(), (MetaData)$md);
            $md = new UnprefixedAttribute("full-class-name", stmt.location().fullClassName(), (MetaData)$md);
            $md = new UnprefixedAttribute("class-type", stmt.location().classType().toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("class", stmt.location().className(), (MetaData)$md);
            $md = new UnprefixedAttribute("package", stmt.location().packageName(), (MetaData)$md);
            return new Elem(null, "statement", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$);
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    /*
     * WARNING - void declaration
     */
    private Node method(MeasuredMethod method) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("branch-rate", method.branchCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-rate", method.statementCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statements-invoked", Integer.toString(method.invokedStatementCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-count", Integer.toString(method.statementCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("name", method.name(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(method.statements().map((Function1 & Serializable)stmt -> this.statement((Statement)stmt)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "statements", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "method", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private Node klass(MeasuredClass klass) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("branch-rate", klass.branchCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-rate", klass.statementCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statements-invoked", Integer.toString(klass.invokedStatementCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-count", Integer.toString(klass.statementCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("filename", this.relativeSource(klass.source()), (MetaData)$md);
        $md = new UnprefixedAttribute("name", klass.fullClassName(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(klass.methods().map((Function1 & Serializable)method -> this.method((MeasuredMethod)method)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "methods", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "class", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private Node pack(MeasuredPackage pack) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("statement-rate", pack.statementCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statements-invoked", Integer.toString(pack.invokedStatementCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-count", Integer.toString(pack.statementCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("name", pack.name(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(pack.classes().map((Function1 & Serializable)klass -> this.klass((MeasuredClass)klass)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "classes", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "package", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    public String escape(String in) {
        StringBuilder out = new StringBuilder();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.charArrayOps(((String)Option$.MODULE$.apply((Object)in).getOrElse((Function0 & Serializable)() -> "")).toCharArray()), (Function1 & Serializable)current -> ScoverageXmlWriter.$anonfun$escape$2(out, BoxesRunTime.unboxToChar((Object)current)));
        return out.mkString();
    }

    public static final /* synthetic */ Object $anonfun$escape$2(StringBuilder out$1, char current) {
        if (current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff') {
            return out$1.append(current);
        }
        return BoxedUnit.UNIT;
    }

    public ScoverageXmlWriter(scala.collection.immutable.Seq<File> sourceDirectories, File outputDir, boolean debug, Option<String> sourceEncoding) {
        this.outputDir = outputDir;
        this.debug = debug;
        this.sourceEncoding = sourceEncoding;
        super(sourceDirectories, outputDir, sourceEncoding);
    }

    public ScoverageXmlWriter(File sourceDir, File outputDir, boolean debug, Option<String> sourceEncoding) {
        this((scala.collection.immutable.Seq<File>)new .colon.colon((Object)sourceDir, (List)Nil$.MODULE$), outputDir, debug, sourceEncoding);
    }
}

