/*
 * Decompiled with CFR 0.152.
 */
package scoverage.reporter;

import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PrettyPrinter;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;
import scoverage.domain.Coverage;
import scoverage.domain.DoubleFormat$;
import scoverage.domain.MeasuredClass;
import scoverage.domain.MeasuredMethod;
import scoverage.domain.MeasuredPackage;
import scoverage.reporter.BaseReportWriter;
import scoverage.reporter.IOUtils$;

@ScalaSignature(bytes="\u0006\u0005I4A\u0001D\u0007\u0001%!Aq\u0003\u0001B\u0001B\u0003%\u0001\u0004\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003'\u0011!y\u0003A!A!\u0002\u0013\u0001\u0004\"\u0002\u001f\u0001\t\u0003i\u0004\"\u0002\u001f\u0001\t\u0003\u0011\u0005\"B$\u0001\t\u0003A\u0005\"\u0002+\u0001\t\u0003)\u0006\"\u00021\u0001\t\u0003\t\u0007\"\u00024\u0001\t\u00039\u0007\"\u00027\u0001\t\u0003i\u0007\"B-\u0001\t\u0003\u0001(AE\"pE\u0016\u0014H/\u001e:b16dwK]5uKJT!AD\b\u0002\u0011I,\u0007o\u001c:uKJT\u0011\u0001E\u0001\ng\u000e|g/\u001a:bO\u0016\u001c\u0001a\u0005\u0002\u0001'A\u0011A#F\u0007\u0002\u001b%\u0011a#\u0004\u0002\u0011\u0005\u0006\u001cXMU3q_J$xK]5uKJ\f\u0011c]8ve\u000e,G)\u001b:fGR|'/[3t!\rI2E\n\b\u00035\u0001r!a\u0007\u0010\u000e\u0003qQ!!H\t\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0012!B:dC2\f\u0017BA\u0011#\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011aH\u0005\u0003I\u0015\u00121aU3r\u0015\t\t#\u0005\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005\u0011\u0011n\u001c\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0003F\u0001\u0003GS2,\u0017!C8viB,H\u000fR5s\u00039\u0019x.\u001e:dK\u0016s7m\u001c3j]\u001e\u00042!\r\u001a5\u001b\u0005\u0011\u0013BA\u001a#\u0005\u0019y\u0005\u000f^5p]B\u0011Q'\u000f\b\u0003m]\u0002\"a\u0007\u0012\n\u0005a\u0012\u0013A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001\u000f\u0012\u0002\rqJg.\u001b;?)\u0011qt\bQ!\u0011\u0005Q\u0001\u0001\"B\f\u0005\u0001\u0004A\u0002\"\u0002\u0018\u0005\u0001\u00041\u0003\"B\u0018\u0005\u0001\u0004\u0001D\u0003\u0002 D\u000b\u001aCQ\u0001R\u0003A\u0002\u0019\nqAY1tK\u0012K'\u000fC\u0003/\u000b\u0001\u0007a\u0005C\u00030\u000b\u0001\u0007\u0001'A\u0003xe&$X\r\u0006\u0002J\u0019B\u0011\u0011GS\u0005\u0003\u0017\n\u0012A!\u00168ji\")QJ\u0002a\u0001\u001d\u0006A1m\u001c<fe\u0006<W\r\u0005\u0002P%6\t\u0001K\u0003\u0002R\u001f\u00051Am\\7bS:L!a\u0015)\u0003\u0011\r{g/\u001a:bO\u0016\fa!\\3uQ>$GC\u0001,]!\t9&,D\u0001Y\u0015\tI&%A\u0002y[2L!a\u0017-\u0003\t9{G-\u001a\u0005\u0006)\u001e\u0001\r!\u0018\t\u0003\u001fzK!a\u0018)\u0003\u001d5+\u0017m];sK\u0012lU\r\u001e5pI\u0006)1\u000e\\1tgR\u0011aK\u0019\u0005\u0006A\"\u0001\ra\u0019\t\u0003\u001f\u0012L!!\u001a)\u0003\u001b5+\u0017m];sK\u0012\u001cE.Y:t\u0003\u0011\u0001\u0018mY6\u0015\u0005YC\u0007\"\u00024\n\u0001\u0004I\u0007CA(k\u0013\tY\u0007KA\bNK\u0006\u001cXO]3e!\u0006\u001c7.Y4f\u0003\u0019\u0019x.\u001e:dKR\u0011aK\u001c\u0005\u0006_*\u0001\rAJ\u0001\u0004gJ\u001cGC\u0001,r\u0011\u0015i5\u00021\u0001O\u0001")
public class CoberturaXmlWriter
extends BaseReportWriter {
    private final scala.collection.immutable.Seq<File> sourceDirectories;
    private final File outputDir;
    private final Option<String> sourceEncoding;

    public void write(Coverage coverage) {
        File file = new File(this.outputDir, "cobertura.xml");
        PrettyPrinter qual$1 = new PrettyPrinter(120, 4);
        Node x$1 = this.xml(coverage);
        NamespaceBinding x$2 = qual$1.format$default$2();
        IOUtils$.MODULE$.writeToFile(file, new StringBuilder(105).append("<?xml version=\"1.0\"?>\n<!DOCTYPE coverage SYSTEM \"https://cobertura.sourceforge.net/xml/coverage-04.dtd\">\n").append(qual$1.format(x$1, x$2)).toString(), this.sourceEncoding);
    }

    /*
     * WARNING - void declaration
     */
    public Node method(MeasuredMethod method) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("complexity", (Seq)new Text("0"), (MetaData)$md);
        $md = new UnprefixedAttribute("branch-rate", DoubleFormat$.MODULE$.twoFractionDigits(method.branchCoverage()), (MetaData)$md);
        $md = new UnprefixedAttribute("line-rate", DoubleFormat$.MODULE$.twoFractionDigits(method.statementCoverage()), (MetaData)$md);
        $md = new UnprefixedAttribute("signature", (Seq)new Text("()V"), (MetaData)$md);
        $md = new UnprefixedAttribute("name", method.name(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(method.statements().map((Function1 & Serializable)stmt -> {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("branch", Boolean.toString(stmt.branch()), (MetaData)$md);
            $md = new UnprefixedAttribute("hits", Integer.toString(stmt.count()), (MetaData)$md);
            $md = new UnprefixedAttribute("number", Integer.toString(stmt.line()), (MetaData)$md);
            return new Elem(null, "line", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$);
        }));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "lines", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "method", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public Node klass(MeasuredClass klass) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("complexity", (Seq)new Text("0"), (MetaData)$md);
        $md = new UnprefixedAttribute("branch-rate", DoubleFormat$.MODULE$.twoFractionDigits(klass.branchCoverage()), (MetaData)$md);
        $md = new UnprefixedAttribute("line-rate", DoubleFormat$.MODULE$.twoFractionDigits(klass.statementCoverage()), (MetaData)$md);
        $md = new UnprefixedAttribute("filename", this.relativeSource(klass.source()), (MetaData)$md);
        $md = new UnprefixedAttribute("name", klass.fullClassName(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(klass.methods().map((Function1 & Serializable)method -> this.method((MeasuredMethod)method)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "methods", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus(klass.statements().map((Function1 & Serializable)stmt -> {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("branch", Boolean.toString(stmt.branch()), (MetaData)$md);
            $md = new UnprefixedAttribute("hits", Integer.toString(stmt.count()), (MetaData)$md);
            $md = new UnprefixedAttribute("number", Integer.toString(stmt.line()), (MetaData)$md);
            return new Elem(null, "line", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$);
        }));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "lines", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "class", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public Node pack(MeasuredPackage pack) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("complexity", (Seq)new Text("0"), (MetaData)$md);
        $md = new UnprefixedAttribute("branch-rate", DoubleFormat$.MODULE$.twoFractionDigits(pack.branchCoverage()), (MetaData)$md);
        $md = new UnprefixedAttribute("line-rate", DoubleFormat$.MODULE$.twoFractionDigits(pack.statementCoverage()), (MetaData)$md);
        $md = new UnprefixedAttribute("name", pack.name(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(pack.classes().map((Function1 & Serializable)klass -> this.klass((MeasuredClass)klass)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "classes", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "package", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public Node source(File src) {
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)src.getCanonicalPath().replace(File.separator, "/"));
        return new Elem(null, "source", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public Node xml(Coverage coverage) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("timestamp", Long.toString(System.currentTimeMillis()), (MetaData)$md);
        $md = new UnprefixedAttribute("version", (Seq)new Text("1.0"), (MetaData)$md);
        $md = new UnprefixedAttribute("complexity", (Seq)new Text("0"), (MetaData)$md);
        $md = new UnprefixedAttribute("branch-rate", DoubleFormat$.MODULE$.twoFractionDigits(coverage.branchCoverage()), (MetaData)$md);
        $md = new UnprefixedAttribute("branches-covered", Integer.toString(coverage.invokedBranchesCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("branches-valid", Integer.toString(coverage.branchCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("lines-covered", Integer.toString(coverage.invokedStatementCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("lines-valid", Integer.toString(coverage.statementCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("line-rate", DoubleFormat$.MODULE$.twoFractionDigits(coverage.statementCoverage()), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("--source"));
        $buf2.$amp$plus((Object)new Elem(null, "source", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(((IterableOps)this.sourceDirectories.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory()))).map((Function1 & Serializable)src -> this.source((File)src)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "sources", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus(coverage.packages().map((Function1 & Serializable)pack -> this.pack((MeasuredPackage)pack)));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "packages", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "coverage", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    public CoberturaXmlWriter(scala.collection.immutable.Seq<File> sourceDirectories, File outputDir, Option<String> sourceEncoding) {
        this.sourceDirectories = sourceDirectories;
        this.outputDir = outputDir;
        this.sourceEncoding = sourceEncoding;
        super(sourceDirectories, outputDir, sourceEncoding);
    }

    public CoberturaXmlWriter(File baseDir, File outputDir, Option<String> sourceEncoding) {
        this((scala.collection.immutable.Seq<File>)new .colon.colon((Object)baseDir, (List)Nil$.MODULE$), outputDir, sourceEncoding);
    }
}

