/*
 * Decompiled with CFR 0.152.
 */
package scoverage.report;

import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.PrettyPrinter;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;
import scoverage.Coverage;
import scoverage.DoubleFormat$;
import scoverage.IOUtils$;
import scoverage.MeasuredClass;
import scoverage.MeasuredMethod;
import scoverage.MeasuredPackage;
import scoverage.report.BaseReportWriter;

@ScalaSignature(bytes="\u0006\u0001\u00054Aa\u0003\u0007\u0001#!Aa\u0003\u0001B\u0001B\u0003%q\u0003\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003&\u0011\u0015q\u0003\u0001\"\u00010\u0011\u0015q\u0003\u0001\"\u00014\u0011\u00159\u0004\u0001\"\u00019\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015A\u0005\u0001\"\u0001`\u0005I\u0019uNY3siV\u0014\u0018\rW7m/JLG/\u001a:\u000b\u00055q\u0011A\u0002:fa>\u0014HOC\u0001\u0010\u0003%\u00198m\u001c<fe\u0006<Wm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0015\u001b\u0005a\u0011BA\u000b\r\u0005A\u0011\u0015m]3SKB|'\u000f^,sSR,'/A\tt_V\u00148-\u001a#je\u0016\u001cGo\u001c:jKN\u00042\u0001\u0007\u0012&\u001d\tIrD\u0004\u0002\u001b;5\t1D\u0003\u0002\u001d!\u00051AH]8pizJ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003A\u0005\nq\u0001]1dW\u0006<WMC\u0001\u001f\u0013\t\u0019CEA\u0002TKFT!\u0001I\u0011\u0011\u0005\u0019ZS\"A\u0014\u000b\u0005!J\u0013AA5p\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\t\u0019KG.Z\u0001\n_V$\b/\u001e;ESJ\fa\u0001P5oSRtDc\u0001\u00192eA\u00111\u0003\u0001\u0005\u0006-\r\u0001\ra\u0006\u0005\u0006[\r\u0001\r!\n\u000b\u0004aQ2\u0004\"B\u001b\u0005\u0001\u0004)\u0013a\u00022bg\u0016$\u0015N\u001d\u0005\u0006[\u0011\u0001\r!J\u0001\u0006oJLG/\u001a\u000b\u0003su\u0002\"AO\u001e\u000e\u0003\u0005J!\u0001P\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006}\u0015\u0001\raP\u0001\tG>4XM]1hKB\u0011\u0001)Q\u0007\u0002\u001d%\u0011!I\u0004\u0002\t\u0007>4XM]1hK\u00061Q.\u001a;i_\u0012$\"!R&\u0011\u0005\u0019KU\"A$\u000b\u0005!\u000b\u0013a\u0001=nY&\u0011!j\u0012\u0002\u0005\u001d>$W\rC\u0003D\r\u0001\u0007A\n\u0005\u0002A\u001b&\u0011aJ\u0004\u0002\u000f\u001b\u0016\f7/\u001e:fI6+G\u000f[8e\u0003\u0015YG.Y:t)\t)\u0015\u000bC\u0003P\u000f\u0001\u0007!\u000b\u0005\u0002A'&\u0011AK\u0004\u0002\u000e\u001b\u0016\f7/\u001e:fI\u000ec\u0017m]:\u0002\tA\f7m\u001b\u000b\u0003\u000b^CQ!\u0016\u0005A\u0002a\u0003\"\u0001Q-\n\u0005is!aD'fCN,(/\u001a3QC\u000e\\\u0017mZ3\u0002\rM|WO]2f)\t)U\fC\u0003_\u0013\u0001\u0007Q%A\u0002te\u000e$\"!\u00121\t\u000byR\u0001\u0019A ")
public class CoberturaXmlWriter
extends BaseReportWriter {
    private final Seq<File> sourceDirectories;
    private final File outputDir;

    public void write(Coverage coverage) {
        File file = new File(this.outputDir, "cobertura.xml");
        PrettyPrinter qual$1 = new PrettyPrinter(120, 4);
        Node x$1 = this.xml(coverage);
        NamespaceBinding x$2 = qual$1.format$default$2();
        IOUtils$.MODULE$.writeToFile(file, new StringBuilder(104).append("<?xml version=\"1.0\"?>\n<!DOCTYPE coverage SYSTEM \"http://cobertura.sourceforge.net/xml/coverage-04.dtd\">\n").append(qual$1.format(x$1, x$2)).toString());
    }

    /*
     * WARNING - void declaration
     */
    public Node method(MeasuredMethod method) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("complexity", (Seq)new Text("0"), (MetaData)$md);
        $md = new UnprefixedAttribute("branch-rate", DoubleFormat$.MODULE$.twoFractionDigits(method.branchCoverage()), (MetaData)$md);
        $md = new UnprefixedAttribute("line-rate", DoubleFormat$.MODULE$.twoFractionDigits(method.statementCoverage()), (MetaData)$md);
        $md = new UnprefixedAttribute("signature", (Seq)new Text("()V"), (MetaData)$md);
        $md = new UnprefixedAttribute("name", method.name(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(method.statements().map((Function1 & Serializable & scala.Serializable)stmt -> {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("branch", Boolean.toString(stmt.branch()), (MetaData)$md);
            $md = new UnprefixedAttribute("hits", Integer.toString(stmt.count()), (MetaData)$md);
            $md = new UnprefixedAttribute("number", Integer.toString(stmt.line()), (MetaData)$md);
            return new Elem(null, "line", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
        }, scala.collection.Iterable$.MODULE$.canBuildFrom()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "lines", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "method", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Node klass(MeasuredClass klass) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("complexity", (Seq)new Text("0"), (MetaData)$md);
        $md = new UnprefixedAttribute("branch-rate", DoubleFormat$.MODULE$.twoFractionDigits(klass.branchCoverage()), (MetaData)$md);
        $md = new UnprefixedAttribute("line-rate", DoubleFormat$.MODULE$.twoFractionDigits(klass.statementCoverage()), (MetaData)$md);
        $md = new UnprefixedAttribute("filename", this.relativeSource(klass.source()).replace(File.separator, "/"), (MetaData)$md);
        $md = new UnprefixedAttribute("name", klass.fullClassName(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(klass.methods().map((Function1 & Serializable & scala.Serializable)method -> this.method((MeasuredMethod)method), Seq$.MODULE$.canBuildFrom()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "methods", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus(klass.statements().map((Function1 & Serializable & scala.Serializable)stmt -> {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("branch", Boolean.toString(stmt.branch()), (MetaData)$md);
            $md = new UnprefixedAttribute("hits", Integer.toString(stmt.count()), (MetaData)$md);
            $md = new UnprefixedAttribute("number", Integer.toString(stmt.line()), (MetaData)$md);
            return new Elem(null, "line", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
        }, scala.collection.Iterable$.MODULE$.canBuildFrom()));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "lines", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "class", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Node pack(MeasuredPackage pack) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("complexity", (Seq)new Text("0"), (MetaData)$md);
        $md = new UnprefixedAttribute("branch-rate", DoubleFormat$.MODULE$.twoFractionDigits(pack.branchCoverage()), (MetaData)$md);
        $md = new UnprefixedAttribute("line-rate", DoubleFormat$.MODULE$.twoFractionDigits(pack.statementCoverage()), (MetaData)$md);
        $md = new UnprefixedAttribute("name", pack.name(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(pack.classes().map((Function1 & Serializable & scala.Serializable)klass -> this.klass((MeasuredClass)klass), Iterable$.MODULE$.canBuildFrom()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "classes", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "package", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Node source(File src) {
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)src.getCanonicalPath().replace(File.separator, "/"));
        return new Elem(null, "source", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Node xml(Coverage coverage) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("timestamp", Long.toString(System.currentTimeMillis()), (MetaData)$md);
        $md = new UnprefixedAttribute("version", (Seq)new Text("1.0"), (MetaData)$md);
        $md = new UnprefixedAttribute("complexity", (Seq)new Text("0"), (MetaData)$md);
        $md = new UnprefixedAttribute("branch-rate", DoubleFormat$.MODULE$.twoFractionDigits(coverage.branchCoverage()), (MetaData)$md);
        $md = new UnprefixedAttribute("branches-covered", Integer.toString(coverage.invokedBranchesCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("branches-valid", Integer.toString(coverage.branchCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("lines-covered", Integer.toString(coverage.invokedStatementCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("lines-valid", Integer.toString(coverage.statementCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("line-rate", DoubleFormat$.MODULE$.twoFractionDigits(coverage.statementCoverage()), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("--source"));
        $buf2.$amp$plus((Object)new Elem(null, "source", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(((TraversableLike)this.sourceDirectories.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory()))).map((Function1 & Serializable & scala.Serializable)src -> this.source((File)src), Seq$.MODULE$.canBuildFrom()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "sources", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus(coverage.packages().map((Function1 & Serializable & scala.Serializable)pack -> this.pack((MeasuredPackage)pack), Seq$.MODULE$.canBuildFrom()));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "packages", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "coverage", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    public CoberturaXmlWriter(Seq<File> sourceDirectories, File outputDir) {
        this.sourceDirectories = sourceDirectories;
        this.outputDir = outputDir;
        super(sourceDirectories, outputDir);
    }

    public CoberturaXmlWriter(File baseDir, File outputDir) {
        this((Seq<File>)((Seq)new .colon.colon((Object)baseDir, (List)Nil$.MODULE$)), outputDir);
    }
}

