/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;

public final class DigestUtils {
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private DigestUtils() {
    }

    public static String string(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException exc) {
            return new String(bytes);
        }
    }

    public static byte[] bytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException exc) {
            return s.getBytes();
        }
    }

    public static byte[] bytes(int i) {
        return new byte[]{(byte)(0xFF & i >>> 24), (byte)(0xFF & i >>> 16), (byte)(0xFF & i >>> 8), (byte)(0xFF & i)};
    }

    public static String hex(byte[] bytes) {
        char[] buffer = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            buffer[i * 2] = hex[(bytes[i] & 0xF0) >> 4];
            buffer[i * 2 + 1] = hex[bytes[i] & 0xF];
        }
        return new String(buffer);
    }

    public static String base64(byte[] bytes) {
        return DatatypeConverter.printBase64Binary((byte[])bytes);
    }

    public static byte[] hash(String s) {
        return DigestUtils.bytes(s.hashCode());
    }

    public static byte[] hash(byte[] bytes) {
        return DigestUtils.hash(DigestUtils.string(bytes));
    }

    public static byte[] sha1(byte[] bytes) {
        return DigestUtils.digest("SHA-1", bytes);
    }

    public static byte[] md5(byte[] bytes) {
        return DigestUtils.digest("MD5", bytes);
    }

    public static byte[] digest(String algorithm, byte[] bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.update(bytes);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException exc) {
            return null;
        }
    }

    public static byte[] best(String s) {
        byte[] bytes = DigestUtils.bytes(s);
        byte[] best = DigestUtils.sha1(bytes);
        if (best == null) {
            best = DigestUtils.md5(bytes);
        }
        if (best == null) {
            best = DigestUtils.hash(s);
        }
        return best;
    }

    public static byte[] best(byte[] bytes) {
        byte[] best = DigestUtils.sha1(bytes);
        if (best == null) {
            best = DigestUtils.md5(bytes);
        }
        if (best == null) {
            best = DigestUtils.hash(bytes);
        }
        return best;
    }

    public static String bestHex(String text) {
        return DigestUtils.hex(DigestUtils.best(text));
    }

    public static String bestHex(byte[] bytes) {
        return DigestUtils.hex(DigestUtils.best(bytes));
    }

    public static String bestBase64(String text) {
        return DigestUtils.base64(DigestUtils.best(text));
    }

    public static String bestBase64(byte[] bytes) {
        return DigestUtils.base64(DigestUtils.best(bytes));
    }
}

