/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

public final class Bytes {
    private Bytes() {
    }

    public static short toShort(byte[] bytes, int off, int len, boolean little) {
        if (bytes.length - off < len) {
            len = bytes.length - off;
        }
        short total = 0;
        int i = 0;
        int ndx = off;
        while (i < len) {
            total = (short)(total | (bytes[ndx] < 0 ? 256 + bytes[ndx] : bytes[ndx]) << (little ? i : len - i - 1) * 8);
            ++i;
            ++ndx;
        }
        return total;
    }

    public static short toShort(byte[] bytes, int off, boolean little) {
        return Bytes.toShort(bytes, off, 2, little);
    }

    public static short toShort(byte[] bytes, boolean little) {
        return Bytes.toShort(bytes, 0, 2, little);
    }

    public static short toShort(short[] bytes, int off, int len, boolean little) {
        if (bytes.length - off < len) {
            len = bytes.length - off;
        }
        short total = 0;
        int i = 0;
        int ndx = off;
        while (i < len) {
            total = (short)(total | bytes[ndx] << (little ? i : len - i - 1) * 8);
            ++i;
            ++ndx;
        }
        return total;
    }

    public static short toShort(short[] bytes, int off, boolean little) {
        return Bytes.toShort(bytes, off, 2, little);
    }

    public static short toShort(short[] bytes, boolean little) {
        return Bytes.toShort(bytes, 0, 2, little);
    }

    public static int toInt(byte[] bytes, int off, int len, boolean little) {
        if (bytes.length - off < len) {
            len = bytes.length - off;
        }
        int total = 0;
        int i = 0;
        int ndx = off;
        while (i < len) {
            total |= (bytes[ndx] < 0 ? 256 + bytes[ndx] : bytes[ndx]) << (little ? i : len - i - 1) * 8;
            ++i;
            ++ndx;
        }
        return total;
    }

    public static int toInt(byte[] bytes, int off, boolean little) {
        return Bytes.toInt(bytes, off, 4, little);
    }

    public static int toInt(byte[] bytes, boolean little) {
        return Bytes.toInt(bytes, 0, 4, little);
    }

    public static int toInt(short[] bytes, int off, int len, boolean little) {
        if (bytes.length - off < len) {
            len = bytes.length - off;
        }
        int total = 0;
        int i = 0;
        int ndx = off;
        while (i < len) {
            total |= bytes[ndx] << (little ? i : len - i - 1) * 8;
            ++i;
            ++ndx;
        }
        return total;
    }

    public static int toInt(short[] bytes, int off, boolean little) {
        return Bytes.toInt(bytes, off, 4, little);
    }

    public static int toInt(short[] bytes, boolean little) {
        return Bytes.toInt(bytes, 0, 4, little);
    }

    public static float toFloat(byte[] bytes, int off, int len, boolean little) {
        return Float.intBitsToFloat(Bytes.toInt(bytes, off, len, little));
    }

    public static float toFloat(byte[] bytes, int off, boolean little) {
        return Bytes.toFloat(bytes, off, 4, little);
    }

    public static float toFloat(byte[] bytes, boolean little) {
        return Bytes.toFloat(bytes, 0, 4, little);
    }

    public static float toFloat(short[] bytes, int off, int len, boolean little) {
        return Float.intBitsToFloat(Bytes.toInt(bytes, off, len, little));
    }

    public static float toFloat(short[] bytes, int off, boolean little) {
        return Bytes.toInt(bytes, off, 4, little);
    }

    public static float toFloat(short[] bytes, boolean little) {
        return Bytes.toInt(bytes, 0, 4, little);
    }

    public static long toLong(byte[] bytes, int off, int len, boolean little) {
        if (bytes.length - off < len) {
            len = bytes.length - off;
        }
        long total = 0L;
        int i = 0;
        int ndx = off;
        while (i < len) {
            total |= (bytes[ndx] < 0 ? 256L + (long)bytes[ndx] : (long)bytes[ndx]) << (little ? i : len - i - 1) * 8;
            ++i;
            ++ndx;
        }
        return total;
    }

    public static long toLong(byte[] bytes, int off, boolean little) {
        return Bytes.toLong(bytes, off, 8, little);
    }

    public static long toLong(byte[] bytes, boolean little) {
        return Bytes.toLong(bytes, 0, 8, little);
    }

    public static long toLong(short[] bytes, int off, int len, boolean little) {
        if (bytes.length - off < len) {
            len = bytes.length - off;
        }
        long total = 0L;
        int i = 0;
        int ndx = off;
        while (i < len) {
            total |= (long)bytes[ndx] << (little ? i : len - i - 1) * 8;
            ++i;
            ++ndx;
        }
        return total;
    }

    public static long toLong(short[] bytes, int off, boolean little) {
        return Bytes.toLong(bytes, off, 8, little);
    }

    public static long toLong(short[] bytes, boolean little) {
        return Bytes.toLong(bytes, 0, 8, little);
    }

    public static double toDouble(byte[] bytes, int off, int len, boolean little) {
        return Double.longBitsToDouble(Bytes.toLong(bytes, off, len, little));
    }

    public static double toDouble(byte[] bytes, int off, boolean little) {
        return Bytes.toDouble(bytes, off, 8, little);
    }

    public static double toDouble(byte[] bytes, boolean little) {
        return Bytes.toDouble(bytes, 0, 8, little);
    }

    public static double toDouble(short[] bytes, int off, int len, boolean little) {
        return Double.longBitsToDouble(Bytes.toLong(bytes, off, len, little));
    }

    public static double toDouble(short[] bytes, int off, boolean little) {
        return Bytes.toDouble(bytes, off, 8, little);
    }

    public static double toDouble(short[] bytes, boolean little) {
        return Bytes.toDouble(bytes, 0, 8, little);
    }

    public static byte[] fromShort(short value, boolean little) {
        byte[] v = new byte[2];
        Bytes.unpack(value, v, 0, 2, little);
        return v;
    }

    public static byte[] fromInt(int value, boolean little) {
        byte[] v = new byte[4];
        Bytes.unpack(value, v, 0, 4, little);
        return v;
    }

    public static byte[] fromFloat(float value, boolean little) {
        byte[] v = new byte[4];
        Bytes.unpack(Float.floatToIntBits(value), v, 0, 4, little);
        return v;
    }

    public static byte[] fromLong(long value, boolean little) {
        byte[] v = new byte[8];
        Bytes.unpack(value, v, 0, 8, little);
        return v;
    }

    public static byte[] fromDouble(double value, boolean little) {
        byte[] v = new byte[8];
        Bytes.unpack(Double.doubleToLongBits(value), v, 0, 8, little);
        return v;
    }

    public static byte[] fromShorts(short[] values, boolean little) {
        byte[] v = new byte[values.length * 2];
        for (int i = 0; i < values.length; ++i) {
            Bytes.unpack(values[i], v, i * 2, 2, little);
        }
        return v;
    }

    public static byte[] fromInts(int[] values, boolean little) {
        byte[] v = new byte[values.length * 4];
        for (int i = 0; i < values.length; ++i) {
            Bytes.unpack(values[i], v, i * 4, 4, little);
        }
        return v;
    }

    public static byte[] fromFloats(float[] values, boolean little) {
        byte[] v = new byte[values.length * 4];
        for (int i = 0; i < values.length; ++i) {
            Bytes.unpack(Float.floatToIntBits(values[i]), v, i * 4, 4, little);
        }
        return v;
    }

    public static byte[] fromLongs(long[] values, boolean little) {
        byte[] v = new byte[values.length * 8];
        for (int i = 0; i < values.length; ++i) {
            Bytes.unpack(values[i], v, i * 8, 8, little);
        }
        return v;
    }

    public static byte[] fromDoubles(double[] values, boolean little) {
        byte[] v = new byte[values.length * 8];
        for (int i = 0; i < values.length; ++i) {
            Bytes.unpack(Double.doubleToLongBits(values[i]), v, i * 8, 8, little);
        }
        return v;
    }

    public static void unpack(long value, byte[] buf, int ndx, int nBytes, boolean little) {
        if (buf.length < ndx + nBytes) {
            throw new IllegalArgumentException("Invalid indices: buf.length=" + buf.length + ", ndx=" + ndx + ", nBytes=" + nBytes);
        }
        if (little) {
            for (int i = 0; i < nBytes; ++i) {
                buf[ndx + i] = (byte)(value >> 8 * i & 0xFFL);
            }
        } else {
            for (int i = 0; i < nBytes; ++i) {
                buf[ndx + i] = (byte)(value >> 8 * (nBytes - i - 1) & 0xFFL);
            }
        }
    }

    public static Object makeArray(byte[] b, int bpp, boolean fp, boolean little) {
        if (bpp == 1) {
            return b;
        }
        if (bpp == 2) {
            short[] s = new short[b.length / 2];
            for (int i = 0; i < s.length; ++i) {
                s[i] = Bytes.toShort(b, i * 2, 2, little);
            }
            return s;
        }
        if (bpp == 4 && fp) {
            float[] f = new float[b.length / 4];
            for (int i = 0; i < f.length; ++i) {
                f[i] = Bytes.toFloat(b, i * 4, 4, little);
            }
            return f;
        }
        if (bpp == 4) {
            int[] i = new int[b.length / 4];
            for (int j = 0; j < i.length; ++j) {
                i[j] = Bytes.toInt(b, j * 4, 4, little);
            }
            return i;
        }
        if (bpp == 8 && fp) {
            double[] d = new double[b.length / 8];
            for (int i = 0; i < d.length; ++i) {
                d[i] = Bytes.toDouble(b, i * 8, 8, little);
            }
            return d;
        }
        if (bpp == 8) {
            long[] l = new long[b.length / 8];
            for (int i = 0; i < l.length; ++i) {
                l[i] = Bytes.toLong(b, i * 8, 8, little);
            }
            return l;
        }
        return null;
    }

    public static Object makeArray2D(byte[] b, int bpp, boolean fp, boolean little, int height) {
        if (b.length % (bpp * height) != 0) {
            throw new IllegalArgumentException("Array length mismatch: b.length=" + b.length + "; bpp=" + bpp + "; height=" + height);
        }
        int width = b.length / (bpp * height);
        if (bpp == 1) {
            byte[][] b2 = new byte[height][width];
            for (int y = 0; y < height; ++y) {
                int index = width * y;
                System.arraycopy(b, index, b2[y], 0, width);
            }
            return b2;
        }
        if (bpp == 2) {
            short[][] s = new short[height][width];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int index = 2 * (width * y + x);
                    s[y][x] = Bytes.toShort(b, index, 2, little);
                }
            }
            return s;
        }
        if (bpp == 4 && fp) {
            float[][] f = new float[height][width];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int index = 4 * (width * y + x);
                    f[y][x] = Bytes.toFloat(b, index, 4, little);
                }
            }
            return f;
        }
        if (bpp == 4) {
            int[][] i = new int[height][width];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int index = 4 * (width * y + x);
                    i[y][x] = Bytes.toInt(b, index, 4, little);
                }
            }
            return i;
        }
        if (bpp == 8 && fp) {
            double[][] d = new double[height][width];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int index = 8 * (width * y + x);
                    d[y][x] = Bytes.toDouble(b, index, 8, little);
                }
            }
            return d;
        }
        if (bpp == 8) {
            long[][] l = new long[height][width];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int index = 8 * (width * y + x);
                    l[y][x] = Bytes.toLong(b, index, 8, little);
                }
            }
            return l;
        }
        return null;
    }

    public static short swap(short x) {
        return (short)(x << 8 | x >> 8 & 0xFF);
    }

    public static char swap(char x) {
        return (char)(x << 8 | x >> 8 & 0xFF);
    }

    public static int swap(int x) {
        return Bytes.swap((short)x) << 16 | Bytes.swap((short)(x >> 16)) & 0xFFFF;
    }

    public static long swap(long x) {
        return (long)Bytes.swap((int)x) << 32 | (long)Bytes.swap((int)(x >> 32)) & 0xFFFFFFFFL;
    }

    public static float swap(float x) {
        return Float.intBitsToFloat(Bytes.swap(Float.floatToIntBits(x)));
    }

    public static double swap(double x) {
        return Double.longBitsToDouble(Bytes.swap(Double.doubleToLongBits(x)));
    }

    public static float[] normalize(float[] data) {
        float[] rtn = new float[data.length];
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        for (float floatValue : data) {
            if (floatValue == Float.POSITIVE_INFINITY || floatValue == Float.NEGATIVE_INFINITY) continue;
            if (floatValue < min) {
                min = floatValue;
            }
            if (!(floatValue > max)) continue;
            max = floatValue;
        }
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == Float.POSITIVE_INFINITY) {
                data[i] = max;
                continue;
            }
            if (data[i] != Float.NEGATIVE_INFINITY) continue;
            data[i] = min;
        }
        float range = max - min;
        for (int i = 0; i < rtn.length; ++i) {
            rtn[i] = (data[i] - min) / range;
        }
        return rtn;
    }

    public static double[] normalize(double[] data) {
        double[] rtn = new double[data.length];
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (double doubleValue : data) {
            if (doubleValue == Double.POSITIVE_INFINITY || doubleValue == Double.NEGATIVE_INFINITY) continue;
            if (doubleValue < min) {
                min = doubleValue;
            }
            if (!(doubleValue > max)) continue;
            max = doubleValue;
        }
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == Double.POSITIVE_INFINITY) {
                data[i] = max;
                continue;
            }
            if (data[i] != Double.NEGATIVE_INFINITY) continue;
            data[i] = min;
        }
        double range = max - min;
        for (int i = 0; i < rtn.length; ++i) {
            rtn[i] = (data[i] - min) / range;
        }
        return rtn;
    }

    public static byte[] makeSigned(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)(b[i] + 128);
        }
        return b;
    }

    public static short[] makeSigned(short[] s) {
        for (int i = 0; i < s.length; ++i) {
            s[i] = (short)(s[i] + 32768);
        }
        return s;
    }

    public static int[] makeSigned(int[] i) {
        for (int j = 0; j < i.length; ++j) {
            i[j] = (int)((long)i[j] + 0x80000000L);
        }
        return i;
    }
}

