/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.convert.ConvertService;
import org.scijava.log.LogService;
import org.scijava.module.DefaultMutableModuleItem;
import org.scijava.parse.ParseService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptService;
import org.scijava.script.process.ScriptProcessor;

@Plugin(type=ScriptProcessor.class)
public class ParameterScriptProcessor
implements ScriptProcessor {
    @Parameter
    private ScriptService scriptService;
    @Parameter
    private ConvertService convertService;
    @Parameter
    private ParseService parser;
    @Parameter
    private LogService log;
    private ScriptInfo info;
    private boolean header;

    @Override
    public void begin(ScriptInfo scriptInfo) {
        this.info = scriptInfo;
        this.info.setReturnValueAppended(true);
        this.header = true;
    }

    @Override
    public String process(String line) {
        if (line.matches("^#@.*")) {
            int at = line.indexOf(64);
            return this.process(line, line.substring(at + 1));
        }
        if (this.header) {
            if (line.matches("^[^\\w]*[^\\w#]@.*")) {
                int at = line.indexOf(64);
                return this.process(line, line.substring(at + 1));
            }
            if (line.matches(".*\\w.*")) {
                this.header = false;
            }
        }
        return line;
    }

    @Override
    public void end() {
        if (this.info.isReturnValueAppended()) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("type", "OUTPUT");
            this.addItem("result", Object.class, attrs, false);
        }
    }

    private String process(String line, String param) {
        if (this.parseParam(param)) {
            return "";
        }
        this.log.warn("Ignoring invalid parameter: " + param);
        return line;
    }

    private boolean parseParam(String param) {
        int lParen = param.indexOf("(");
        int rParen = param.lastIndexOf(")");
        if (rParen < lParen) {
            return false;
        }
        if (lParen < 0) {
            return this.parseParam(param, this.parseAttrs("()"));
        }
        String cutParam = param.substring(0, lParen) + param.substring(rParen + 1);
        String attrs = param.substring(lParen + 1, rParen);
        return this.parseParam(cutParam, this.parseAttrs(attrs));
    }

    private boolean parseParam(String param, Map<String, Object> attrs) {
        String varName;
        String typeName;
        String[] tokens = param.trim().split("[ \t\n]+");
        if (tokens.length < 1) {
            return false;
        }
        String maybeIOType = tokens[0].toUpperCase();
        if (this.isIOType(maybeIOType)) {
            if (tokens.length == 2) {
                typeName = "Object";
                varName = tokens[1];
            } else if (tokens.length == 3) {
                typeName = tokens[1];
                varName = tokens[2];
            } else {
                return false;
            }
            attrs.put("type", maybeIOType);
        } else {
            if (tokens.length < 2) {
                return false;
            }
            typeName = tokens[0];
            varName = tokens[1];
        }
        try {
            Class<?> type = this.scriptService.lookupClass(typeName);
            this.addItem(varName, type, attrs, true);
        }
        catch (ScriptException exc) {
            this.log.warn("Invalid class: " + typeName, exc);
            return false;
        }
        if ("result".equals(varName)) {
            this.info.setReturnValueAppended(false);
        }
        return true;
    }

    private Map<String, Object> parseAttrs(String attrs) {
        return this.parser.parse(attrs, false).asMap();
    }

    private boolean isIOType(String token) {
        return this.convertService.convert((Object)token.toUpperCase(), ItemIO.class) != null;
    }

    private <T> void addItem(String name, Class<T> type, Map<String, Object> attrs, boolean explicit) {
        DefaultMutableModuleItem<T> item = new DefaultMutableModuleItem<T>(this.info, name, type);
        for (String key : attrs.keySet()) {
            Object value = attrs.get(key);
            this.assignAttribute(item, key, value);
        }
        if (item.isInput()) {
            this.info.registerInput(item);
        }
        if (item.isOutput()) {
            this.info.registerOutput(item);
            if (explicit) {
                this.info.setReturnValueAppended(false);
            }
        }
    }

    private <T> void assignAttribute(DefaultMutableModuleItem<T> item, String k, Object v) {
        if (this.is(k, "callback")) {
            item.setCallback(this.as(v, String.class));
        } else if (this.is(k, "choices")) {
            item.setChoices(this.asList(v, item.getType()));
        } else if (this.is(k, "columns")) {
            item.setColumnCount(this.as(v, Integer.TYPE));
        } else if (this.is(k, "description")) {
            item.setDescription(this.as(v, String.class));
        } else if (this.is(k, "initializer")) {
            item.setInitializer(this.as(v, String.class));
        } else if (this.is(k, "validater")) {
            item.setValidater(this.as(v, String.class));
        } else if (this.is(k, "type")) {
            item.setIOType(this.as(v, ItemIO.class));
        } else if (this.is(k, "label")) {
            item.setLabel(this.as(v, String.class));
        } else if (this.is(k, "max")) {
            item.setMaximumValue(this.as(v, item.getType()));
        } else if (this.is(k, "min")) {
            item.setMinimumValue(this.as(v, item.getType()));
        } else if (this.is(k, "name")) {
            item.setName(this.as(v, String.class));
        } else if (this.is(k, "autoFill")) {
            item.setAutoFill(this.as(v, Boolean.TYPE));
        } else if (this.is(k, "persist")) {
            item.setPersisted(this.as(v, Boolean.TYPE));
        } else if (this.is(k, "persistKey")) {
            item.setPersistKey(this.as(v, String.class));
        } else if (this.is(k, "required")) {
            item.setRequired(this.as(v, Boolean.TYPE));
        } else if (this.is(k, "softMax")) {
            item.setSoftMaximum(this.as(v, item.getType()));
        } else if (this.is(k, "softMin")) {
            item.setSoftMinimum(this.as(v, item.getType()));
        } else if (this.is(k, "stepSize")) {
            item.setStepSize(this.as(v, Double.TYPE));
        } else if (this.is(k, "style")) {
            item.setWidgetStyle(this.as(v, String.class));
        } else if (this.is(k, "visibility")) {
            item.setVisibility(this.as(v, ItemVisibility.class));
        } else if (this.is(k, "value")) {
            item.setDefaultValue(this.as(v, item.getType()));
        } else {
            item.set(k, v.toString());
        }
    }

    private boolean is(String key, String desired) {
        return desired.equalsIgnoreCase(key);
    }

    private <T> T as(Object v, Class<T> type) {
        T converted = this.convertService.convert(v, type);
        if (converted != null) {
            return converted;
        }
        return this.convertService.convert((Object)v.toString(), type);
    }

    private <T> List<T> asList(Object v, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        List list = this.as(v, List.class);
        for (Object item : list) {
            result.add(this.as(item, type));
        }
        return result;
    }
}

