/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.parse;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.scijava.parse.Item;
import org.scijava.parse.Items;
import org.scijava.parse.ParseService;
import org.scijava.parsington.Variable;
import org.scijava.parsington.eval.DefaultTreeEvaluator;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.util.ObjectArray;

@Plugin(type=Service.class)
public class DefaultParseService
extends AbstractService
implements ParseService {
    @Override
    public Items parse(String arg, boolean strict) {
        if (arg == null) {
            throw new NullPointerException("arg must not be null");
        }
        return new ItemsList(arg, strict);
    }

    private static class ItemsList
    extends ObjectArray<Item>
    implements Items {
        public ItemsList(String arg, boolean strict) {
            super(Item.class);
            this.parseItems(arg, strict);
        }

        @Override
        public Map<String, Object> asMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (Item item : this) {
                map.put(item.name(), item.value());
            }
            return map;
        }

        @Override
        public boolean isMap() {
            for (Item item : this) {
                if (item.name() != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isList() {
            for (Item item : this) {
                if (item.name() == null) continue;
                return false;
            }
            return true;
        }

        private void parseItems(String arg, boolean strict) {
            DefaultTreeEvaluator e = new DefaultTreeEvaluator();
            e.setStrict(strict);
            Object result = e.evaluate("(" + arg + ")");
            if (result == null) {
                throw new IllegalStateException("Error parsing string: '" + arg + "'");
            }
            List<Object> list = result instanceof List ? (List<Object>)result : Collections.singletonList(result);
            for (Object o : list) {
                Object value;
                String name;
                if (o instanceof Variable) {
                    Variable v = (Variable)o;
                    name = v.getToken();
                    value = e.value((Object)v);
                } else {
                    name = null;
                    value = o;
                }
                this.add(new Item(){

                    @Override
                    public String name() {
                        return name;
                    }

                    @Override
                    public Object value() {
                        return value;
                    }
                });
            }
        }
    }
}

