/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io;

import java.io.IOException;
import org.scijava.io.IOPlugin;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;
import org.scijava.plugin.HandlerService;
import org.scijava.service.SciJavaService;

public interface IOService
extends HandlerService<Location, IOPlugin<?>>,
SciJavaService {
    default public IOPlugin<?> getOpener(String source) {
        return this.getOpener(new FileLocation(source));
    }

    default public IOPlugin<?> getOpener(Location source) {
        for (IOPlugin handler : this.getInstances()) {
            if (!handler.supportsOpen(source)) continue;
            return handler;
        }
        return null;
    }

    default public <D> IOPlugin<D> getSaver(D data, String destination) {
        return this.getSaver(data, new FileLocation(destination));
    }

    default public <D> IOPlugin<D> getSaver(D data, Location destination) {
        for (IOPlugin handler : this.getInstances()) {
            if (!handler.supportsSave(data, destination)) continue;
            IOPlugin typedHandler = handler;
            return typedHandler;
        }
        return null;
    }

    public Object open(String var1) throws IOException;

    default public Object open(Location source) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void save(Object var1, String var2) throws IOException;

    default public void save(Object data, Location destination) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public Class<IOPlugin<?>> getPluginType() {
        return IOPlugin.class;
    }

    @Override
    default public Class<Location> getType() {
        return Location.class;
    }
}

