/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.Converter;
import org.scijava.plugin.Plugin;
import org.scijava.util.ArrayUtils;
import org.scijava.util.Types;

@Plugin(type=Converter.class, priority=-1000000.0)
public class DefaultConverter
extends AbstractConverter<Object, Object> {
    @Override
    public Object convert(Object src, Type dest) {
        Class<?> destClass;
        Class<?> saneDest;
        if (src instanceof CharSequence && dest == char[].class) {
            return ((CharSequence)src).toString().toCharArray();
        }
        Type componentType = Types.component(dest);
        if (componentType != null) {
            return this.convertToArray(src, Types.raw(componentType));
        }
        Class<?> cClass = this.collectionClass(dest);
        if (cClass != null) {
            Object collection;
            Object elementType = Types.param(dest, Collection.class, 0);
            if (elementType == null) {
                elementType = Object.class;
            }
            if ((collection = this.convertToCollection(src, cClass, (Type)elementType)) != null) {
                return collection;
            }
        }
        if (Types.isInstance(src, saneDest = Types.box(destClass = Types.raw(dest)))) {
            return src;
        }
        if (src instanceof Number) {
            Number number = (Number)src;
            if (saneDest == Byte.class) {
                return number.byteValue();
            }
            if (saneDest == Double.class) {
                return number.doubleValue();
            }
            if (saneDest == Float.class) {
                return Float.valueOf(number.floatValue());
            }
            if (saneDest == Integer.class) {
                return number.intValue();
            }
            if (saneDest == Long.class) {
                return number.longValue();
            }
            if (saneDest == Short.class) {
                return number.shortValue();
            }
        }
        if (src instanceof String) {
            String s = (String)src;
            if (s.isEmpty()) {
                return Types.nullValue(saneDest);
            }
            if (saneDest == Character.class) {
                return new Character(s.charAt(0));
            }
            if (saneDest.isEnum()) {
                try {
                    return Types.enumValue(s, saneDest);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (saneDest == String.class) {
            return src.toString();
        }
        try {
            Constructor<?> ctor = this.getConstructor(saneDest, src.getClass());
            if (ctor == null) {
                return null;
            }
            return ctor.newInstance(src);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exc) {
            return Types.nullValue(destClass);
        }
    }

    @Override
    public <T> T convert(Object src, Class<T> dest) {
        Class<T> destType = dest;
        Object result = this.convert(src, (Type)destType);
        return (T)result;
    }

    @Override
    public Class<Object> getOutputType() {
        return Object.class;
    }

    @Override
    public Class<Object> getInputType() {
        return Object.class;
    }

    private Constructor<?> getConstructor(Class<?> type, Class<?> argType) {
        for (Constructor<?> ctor : type.getConstructors()) {
            Class<?>[] params = ctor.getParameterTypes();
            if (params.length != 1 || !Types.isAssignable(Types.box(argType), Types.box(params[0]))) continue;
            return ctor;
        }
        return null;
    }

    private boolean isArray(Type type) {
        return Types.component(type) != null;
    }

    private Class<?> collectionClass(Type type) {
        return Types.raws(type).stream().filter(t -> Types.isAssignable(t, Collection.class)).findFirst().orElse(null);
    }

    private Object convertToArray(Object value, Class<?> componentType) {
        Collection<?> items = ArrayUtils.toCollection(value);
        Object array = Array.newInstance(componentType, items.size());
        int index = 0;
        for (Object item : items) {
            Array.set(array, index++, this.convert(item, componentType));
        }
        return array;
    }

    private Object convertToCollection(Object value, Class<?> collectionType, Type elementType) {
        Collection<Object> collection = this.createCollection(collectionType);
        if (collection == null) {
            return null;
        }
        Collection<?> items = ArrayUtils.toCollection(value);
        for (Object item : items) {
            collection.add(this.convert(item, elementType));
        }
        return collection;
    }

    private Collection<Object> createCollection(Class<?> type) {
        if (type == Queue.class || type == Deque.class) {
            type = ArrayDeque.class;
        } else if (type == Set.class) {
            type = LinkedHashSet.class;
        } else if (type == List.class || type == Collection.class) {
            type = ArrayList.class;
        } else if (type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
            return null;
        }
        try {
            Collection c = (Collection)type.newInstance();
            return c;
        }
        catch (InstantiationException exc) {
            return null;
        }
        catch (IllegalAccessException exc) {
            return null;
        }
    }

    @Override
    public boolean canConvert(Class<?> src, Class<?> dest) {
        if (this.isArray(dest)) {
            return true;
        }
        Class<?> cClass = this.collectionClass(dest);
        if (cClass != null && this.createCollection(cClass) != null) {
            return true;
        }
        Class<?> saneDest = Types.box(dest);
        if (Types.isAssignable(Types.box(src), Number.class) && (Types.isByte(saneDest) || Types.isDouble(saneDest) || Types.isFloat(saneDest) || Types.isInteger(saneDest) || Types.isLong(saneDest) || Types.isShort(saneDest))) {
            return true;
        }
        if (saneDest == String.class) {
            return true;
        }
        if (Types.isAssignable(src, String.class)) {
            if (saneDest == Character.class) {
                return true;
            }
            if (dest.isEnum()) {
                return true;
            }
        }
        return this.getConstructor(saneDest, src) != null;
    }
}

