/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.scijava.util.ColorRGB;

public final class Colors {
    public static final ColorRGB ALICEBLUE = new ColorRGB(240, 248, 255);
    public static final ColorRGB ANTIQUEWHITE = new ColorRGB(250, 235, 215);
    public static final ColorRGB AQUA = new ColorRGB(0, 255, 255);
    public static final ColorRGB AQUAMARINE = new ColorRGB(127, 255, 212);
    public static final ColorRGB AZURE = new ColorRGB(240, 255, 255);
    public static final ColorRGB BEIGE = new ColorRGB(245, 245, 220);
    public static final ColorRGB BISQUE = new ColorRGB(255, 228, 196);
    public static final ColorRGB BLACK = new ColorRGB(0, 0, 0);
    public static final ColorRGB BLANCHEDALMOND = new ColorRGB(255, 235, 205);
    public static final ColorRGB BLUE = new ColorRGB(0, 0, 255);
    public static final ColorRGB BLUEVIOLET = new ColorRGB(138, 43, 226);
    public static final ColorRGB BROWN = new ColorRGB(165, 42, 42);
    public static final ColorRGB BURLYWOOD = new ColorRGB(222, 184, 135);
    public static final ColorRGB CADETBLUE = new ColorRGB(95, 158, 160);
    public static final ColorRGB CHARTREUSE = new ColorRGB(127, 255, 0);
    public static final ColorRGB CHOCOLATE = new ColorRGB(210, 105, 30);
    public static final ColorRGB CORAL = new ColorRGB(255, 127, 80);
    public static final ColorRGB CORNFLOWERBLUE = new ColorRGB(100, 149, 237);
    public static final ColorRGB CORNSILK = new ColorRGB(255, 248, 220);
    public static final ColorRGB CRIMSON = new ColorRGB(220, 20, 60);
    public static final ColorRGB CYAN = new ColorRGB(0, 255, 255);
    public static final ColorRGB DARKBLUE = new ColorRGB(0, 0, 139);
    public static final ColorRGB DARKCYAN = new ColorRGB(0, 139, 139);
    public static final ColorRGB DARKGOLDENROD = new ColorRGB(184, 134, 11);
    public static final ColorRGB DARKGRAY = new ColorRGB(169, 169, 169);
    public static final ColorRGB DARKGREEN = new ColorRGB(0, 100, 0);
    public static final ColorRGB DARKGREY = DARKGRAY;
    public static final ColorRGB DARKKHAKI = new ColorRGB(189, 183, 107);
    public static final ColorRGB DARKMAGENTA = new ColorRGB(139, 0, 139);
    public static final ColorRGB DARKOLIVEGREEN = new ColorRGB(85, 107, 47);
    public static final ColorRGB DARKORANGE = new ColorRGB(255, 140, 0);
    public static final ColorRGB DARKORCHID = new ColorRGB(153, 50, 204);
    public static final ColorRGB DARKRED = new ColorRGB(139, 0, 0);
    public static final ColorRGB DARKSALMON = new ColorRGB(233, 150, 122);
    public static final ColorRGB DARKSEAGREEN = new ColorRGB(143, 188, 143);
    public static final ColorRGB DARKSLATEBLUE = new ColorRGB(72, 61, 139);
    public static final ColorRGB DARKSLATEGRAY;
    public static final ColorRGB DARKSLATEGREY;
    public static final ColorRGB DARKTURQUOISE;
    public static final ColorRGB DARKVIOLET;
    public static final ColorRGB DEEPPINK;
    public static final ColorRGB DEEPSKYBLUE;
    public static final ColorRGB DIMGRAY;
    public static final ColorRGB DIMGREY;
    public static final ColorRGB DODGERBLUE;
    public static final ColorRGB FIREBRICK;
    public static final ColorRGB FLORALWHITE;
    public static final ColorRGB FORESTGREEN;
    public static final ColorRGB FUCHSIA;
    public static final ColorRGB GAINSBORO;
    public static final ColorRGB GHOSTWHITE;
    public static final ColorRGB GOLD;
    public static final ColorRGB GOLDENROD;
    public static final ColorRGB GRAY;
    public static final ColorRGB GREEN;
    public static final ColorRGB GREENYELLOW;
    public static final ColorRGB GREY;
    public static final ColorRGB HONEYDEW;
    public static final ColorRGB HOTPINK;
    public static final ColorRGB INDIANRED;
    public static final ColorRGB INDIGO;
    public static final ColorRGB IVORY;
    public static final ColorRGB KHAKI;
    public static final ColorRGB LAVENDER;
    public static final ColorRGB LAVENDERBLUSH;
    public static final ColorRGB LAWNGREEN;
    public static final ColorRGB LEMONCHIFFON;
    public static final ColorRGB LIGHTBLUE;
    public static final ColorRGB LIGHTCORAL;
    public static final ColorRGB LIGHTCYAN;
    public static final ColorRGB LIGHTGOLDENRODYELLOW;
    public static final ColorRGB LIGHTGRAY;
    public static final ColorRGB LIGHTGREEN;
    public static final ColorRGB LIGHTGREY;
    public static final ColorRGB LIGHTPINK;
    public static final ColorRGB LIGHTSALMON;
    public static final ColorRGB LIGHTSEAGREEN;
    public static final ColorRGB LIGHTSKYBLUE;
    public static final ColorRGB LIGHTSLATEGRAY;
    public static final ColorRGB LIGHTSLATEGREY;
    public static final ColorRGB LIGHTSTEELBLUE;
    public static final ColorRGB LIGHTYELLOW;
    public static final ColorRGB LIME;
    public static final ColorRGB LIMEGREEN;
    public static final ColorRGB LINEN;
    public static final ColorRGB MAGENTA;
    public static final ColorRGB MAROON;
    public static final ColorRGB MEDIUMAQUAMARINE;
    public static final ColorRGB MEDIUMBLUE;
    public static final ColorRGB MEDIUMORCHID;
    public static final ColorRGB MEDIUMPURPLE;
    public static final ColorRGB MEDIUMSEAGREEN;
    public static final ColorRGB MEDIUMSLATEBLUE;
    public static final ColorRGB MEDIUMSPRINGGREEN;
    public static final ColorRGB MEDIUMTURQUOISE;
    public static final ColorRGB MEDIUMVIOLETRED;
    public static final ColorRGB MIDNIGHTBLUE;
    public static final ColorRGB MINTCREAM;
    public static final ColorRGB MISTYROSE;
    public static final ColorRGB MOCCASIN;
    public static final ColorRGB NAVAJOWHITE;
    public static final ColorRGB NAVY;
    public static final ColorRGB OLDLACE;
    public static final ColorRGB OLIVE;
    public static final ColorRGB OLIVEDRAB;
    public static final ColorRGB ORANGE;
    public static final ColorRGB ORANGERED;
    public static final ColorRGB ORCHID;
    public static final ColorRGB PALEGOLDENROD;
    public static final ColorRGB PALEGREEN;
    public static final ColorRGB PALETURQUOISE;
    public static final ColorRGB PALEVIOLETRED;
    public static final ColorRGB PAPAYAWHIP;
    public static final ColorRGB PEACHPUFF;
    public static final ColorRGB PERU;
    public static final ColorRGB PINK;
    public static final ColorRGB PLUM;
    public static final ColorRGB POWDERBLUE;
    public static final ColorRGB PURPLE;
    public static final ColorRGB RED;
    public static final ColorRGB ROSYBROWN;
    public static final ColorRGB ROYALBLUE;
    public static final ColorRGB SADDLEBROWN;
    public static final ColorRGB SALMON;
    public static final ColorRGB SANDYBROWN;
    public static final ColorRGB SEAGREEN;
    public static final ColorRGB SEASHELL;
    public static final ColorRGB SIENNA;
    public static final ColorRGB SILVER;
    public static final ColorRGB SKYBLUE;
    public static final ColorRGB SLATEBLUE;
    public static final ColorRGB SLATEGRAY;
    public static final ColorRGB SLATEGREY;
    public static final ColorRGB SNOW;
    public static final ColorRGB SPRINGGREEN;
    public static final ColorRGB STEELBLUE;
    public static final ColorRGB TAN;
    public static final ColorRGB TEAL;
    public static final ColorRGB THISTLE;
    public static final ColorRGB TOMATO;
    public static final ColorRGB TURQUOISE;
    public static final ColorRGB VIOLET;
    public static final ColorRGB WHEAT;
    public static final ColorRGB WHITE;
    public static final ColorRGB WHITESMOKE;
    public static final ColorRGB YELLOW;
    public static final ColorRGB YELLOWGREEN;
    private static final Map<String, ColorRGB> COLORS;

    private Colors() {
    }

    public static ColorRGB getColor(String name) {
        return COLORS.get(name);
    }

    public static String getName(ColorRGB color) {
        if (color == null) {
            return null;
        }
        for (String name : COLORS.keySet()) {
            ColorRGB value = COLORS.get(name);
            if (!color.equals(value)) continue;
            return name;
        }
        return null;
    }

    public static Map<String, ColorRGB> map() {
        return Collections.unmodifiableMap(COLORS);
    }

    public static Collection<ColorRGB> values() {
        return COLORS.values();
    }

    public static ColorRGB getClosestPresetColor(ColorRGB color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        ColorRGB bestSoFar = null;
        double distance = Double.POSITIVE_INFINITY;
        boolean firstPass = true;
        for (ColorRGB presetColor : COLORS.values()) {
            double db;
            double dg;
            if (firstPass) {
                bestSoFar = presetColor;
                firstPass = false;
                continue;
            }
            double dr = presetColor.getRed() - r;
            double thisDist = dr * dr + (dg = (double)(presetColor.getGreen() - g)) * dg + (db = (double)(presetColor.getBlue() - b)) * db;
            if (!(thisDist < distance)) continue;
            bestSoFar = presetColor;
            distance = thisDist;
        }
        return bestSoFar;
    }

    static {
        DARKSLATEGREY = DARKSLATEGRAY = new ColorRGB(47, 79, 79);
        DARKTURQUOISE = new ColorRGB(0, 206, 209);
        DARKVIOLET = new ColorRGB(148, 0, 211);
        DEEPPINK = new ColorRGB(255, 20, 147);
        DEEPSKYBLUE = new ColorRGB(0, 191, 255);
        DIMGREY = DIMGRAY = new ColorRGB(105, 105, 105);
        DODGERBLUE = new ColorRGB(30, 144, 255);
        FIREBRICK = new ColorRGB(178, 34, 34);
        FLORALWHITE = new ColorRGB(255, 250, 240);
        FORESTGREEN = new ColorRGB(34, 139, 34);
        FUCHSIA = new ColorRGB(255, 0, 255);
        GAINSBORO = new ColorRGB(220, 220, 220);
        GHOSTWHITE = new ColorRGB(248, 248, 255);
        GOLD = new ColorRGB(255, 215, 0);
        GOLDENROD = new ColorRGB(218, 165, 32);
        GRAY = new ColorRGB(128, 128, 128);
        GREEN = new ColorRGB(0, 128, 0);
        GREENYELLOW = new ColorRGB(173, 255, 47);
        GREY = GRAY;
        HONEYDEW = new ColorRGB(240, 255, 240);
        HOTPINK = new ColorRGB(255, 105, 180);
        INDIANRED = new ColorRGB(205, 92, 92);
        INDIGO = new ColorRGB(75, 0, 130);
        IVORY = new ColorRGB(255, 255, 240);
        KHAKI = new ColorRGB(240, 230, 140);
        LAVENDER = new ColorRGB(230, 230, 250);
        LAVENDERBLUSH = new ColorRGB(255, 240, 245);
        LAWNGREEN = new ColorRGB(124, 252, 0);
        LEMONCHIFFON = new ColorRGB(255, 250, 205);
        LIGHTBLUE = new ColorRGB(173, 216, 230);
        LIGHTCORAL = new ColorRGB(240, 128, 128);
        LIGHTCYAN = new ColorRGB(224, 255, 255);
        LIGHTGOLDENRODYELLOW = new ColorRGB(250, 250, 210);
        LIGHTGRAY = new ColorRGB(211, 211, 211);
        LIGHTGREEN = new ColorRGB(144, 238, 144);
        LIGHTGREY = LIGHTGRAY;
        LIGHTPINK = new ColorRGB(255, 182, 193);
        LIGHTSALMON = new ColorRGB(255, 160, 122);
        LIGHTSEAGREEN = new ColorRGB(32, 178, 170);
        LIGHTSKYBLUE = new ColorRGB(135, 206, 250);
        LIGHTSLATEGREY = LIGHTSLATEGRAY = new ColorRGB(119, 136, 153);
        LIGHTSTEELBLUE = new ColorRGB(176, 196, 222);
        LIGHTYELLOW = new ColorRGB(255, 255, 224);
        LIME = new ColorRGB(0, 255, 0);
        LIMEGREEN = new ColorRGB(50, 205, 50);
        LINEN = new ColorRGB(250, 240, 230);
        MAGENTA = new ColorRGB(255, 0, 255);
        MAROON = new ColorRGB(128, 0, 0);
        MEDIUMAQUAMARINE = new ColorRGB(102, 205, 170);
        MEDIUMBLUE = new ColorRGB(0, 0, 205);
        MEDIUMORCHID = new ColorRGB(186, 85, 211);
        MEDIUMPURPLE = new ColorRGB(147, 112, 219);
        MEDIUMSEAGREEN = new ColorRGB(60, 179, 113);
        MEDIUMSLATEBLUE = new ColorRGB(123, 104, 238);
        MEDIUMSPRINGGREEN = new ColorRGB(0, 250, 154);
        MEDIUMTURQUOISE = new ColorRGB(72, 209, 204);
        MEDIUMVIOLETRED = new ColorRGB(199, 21, 133);
        MIDNIGHTBLUE = new ColorRGB(25, 25, 112);
        MINTCREAM = new ColorRGB(245, 255, 250);
        MISTYROSE = new ColorRGB(255, 228, 225);
        MOCCASIN = new ColorRGB(255, 228, 181);
        NAVAJOWHITE = new ColorRGB(255, 222, 173);
        NAVY = new ColorRGB(0, 0, 128);
        OLDLACE = new ColorRGB(253, 245, 230);
        OLIVE = new ColorRGB(128, 128, 0);
        OLIVEDRAB = new ColorRGB(107, 142, 35);
        ORANGE = new ColorRGB(255, 165, 0);
        ORANGERED = new ColorRGB(255, 69, 0);
        ORCHID = new ColorRGB(218, 112, 214);
        PALEGOLDENROD = new ColorRGB(238, 232, 170);
        PALEGREEN = new ColorRGB(152, 251, 152);
        PALETURQUOISE = new ColorRGB(175, 238, 238);
        PALEVIOLETRED = new ColorRGB(219, 112, 147);
        PAPAYAWHIP = new ColorRGB(255, 239, 213);
        PEACHPUFF = new ColorRGB(255, 218, 185);
        PERU = new ColorRGB(205, 133, 63);
        PINK = new ColorRGB(255, 192, 203);
        PLUM = new ColorRGB(221, 160, 221);
        POWDERBLUE = new ColorRGB(176, 224, 230);
        PURPLE = new ColorRGB(128, 0, 128);
        RED = new ColorRGB(255, 0, 0);
        ROSYBROWN = new ColorRGB(188, 143, 143);
        ROYALBLUE = new ColorRGB(65, 105, 225);
        SADDLEBROWN = new ColorRGB(139, 69, 19);
        SALMON = new ColorRGB(250, 128, 114);
        SANDYBROWN = new ColorRGB(244, 164, 96);
        SEAGREEN = new ColorRGB(46, 139, 87);
        SEASHELL = new ColorRGB(255, 245, 238);
        SIENNA = new ColorRGB(160, 82, 45);
        SILVER = new ColorRGB(192, 192, 192);
        SKYBLUE = new ColorRGB(135, 206, 235);
        SLATEBLUE = new ColorRGB(106, 90, 205);
        SLATEGREY = SLATEGRAY = new ColorRGB(112, 128, 144);
        SNOW = new ColorRGB(255, 250, 250);
        SPRINGGREEN = new ColorRGB(0, 255, 127);
        STEELBLUE = new ColorRGB(70, 130, 180);
        TAN = new ColorRGB(210, 180, 140);
        TEAL = new ColorRGB(0, 128, 128);
        THISTLE = new ColorRGB(216, 191, 216);
        TOMATO = new ColorRGB(255, 99, 71);
        TURQUOISE = new ColorRGB(64, 224, 208);
        VIOLET = new ColorRGB(238, 130, 238);
        WHEAT = new ColorRGB(245, 222, 179);
        WHITE = new ColorRGB(255, 255, 255);
        WHITESMOKE = new ColorRGB(245, 245, 245);
        YELLOW = new ColorRGB(255, 255, 0);
        YELLOWGREEN = new ColorRGB(154, 205, 50);
        COLORS = new HashMap<String, ColorRGB>();
        for (Field f : Colors.class.getDeclaredFields()) {
            Object value;
            try {
                value = f.get(null);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (!(value instanceof ColorRGB)) continue;
            ColorRGB color = (ColorRGB)value;
            COLORS.put(f.getName().toLowerCase(), color);
        }
    }
}

