/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module.process;

import org.scijava.Cancelable;
import org.scijava.log.LogService;
import org.scijava.module.MethodCallException;
import org.scijava.module.Module;
import org.scijava.module.process.AbstractPreprocessorPlugin;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=PreprocessorPlugin.class, priority=100.0)
public class InitPreprocessor
extends AbstractPreprocessorPlugin {
    @Parameter(required=false)
    private LogService log;

    @Override
    public void process(Module module) {
        try {
            module.initialize();
            if (this.isCanceled(module)) {
                this.cancel(this.getCancelReason(module));
            }
        }
        catch (MethodCallException exc) {
            if (this.log != null) {
                this.log.error(exc);
            }
            String moduleClass = module.getInfo().getDelegateClassName();
            this.cancel("The module \"" + moduleClass + "\" failed to initialize.");
        }
    }

    private boolean isCanceled(Module module) {
        return module instanceof Cancelable && ((Cancelable)((Object)module)).isCanceled();
    }

    private String getCancelReason(Module module) {
        if (!(module instanceof Cancelable)) {
            return null;
        }
        String cancelReason = ((Cancelable)((Object)module)).getCancelReason();
        return cancelReason == null ? "" : cancelReason;
    }
}

