/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Type;
import java.util.Collection;
import org.scijava.convert.ConversionRequest;
import org.scijava.convert.Converter;
import org.scijava.object.ObjectService;
import org.scijava.plugin.AbstractHandlerPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.util.Types;

public abstract class AbstractConverter<I, O>
extends AbstractHandlerPlugin<ConversionRequest>
implements Converter<I, O> {
    @Parameter(required=false)
    private ObjectService objectService;

    @Override
    public boolean canConvert(ConversionRequest request) {
        Object src = request.sourceObject();
        if (src == null) {
            Class<?> srcClass = request.sourceClass();
            if (request.destType() != null) {
                return this.canConvert(srcClass, request.destType());
            }
            return this.canConvert(srcClass, request.destClass());
        }
        if (request.destType() != null) {
            return this.canConvert(src, request.destType());
        }
        return this.canConvert(src, request.destClass());
    }

    @Override
    public boolean canConvert(Object src, Type dest) {
        if (src == null) {
            return false;
        }
        Class<?> srcClass = src.getClass();
        return this.canConvert(srcClass, dest);
    }

    @Override
    public boolean canConvert(Object src, Class<?> dest) {
        if (src == null) {
            return false;
        }
        Class<?> srcClass = src.getClass();
        return this.canConvert(srcClass, dest);
    }

    @Override
    public boolean canConvert(Class<?> src, Class<?> dest) {
        if (src == null) {
            return false;
        }
        Class<?> saneSrc = Types.box(src);
        Class<?> saneDest = Types.box(dest);
        return Types.isAssignable(saneSrc, this.getInputType()) && Types.isAssignable(this.getOutputType(), saneDest);
    }

    @Override
    public Object convert(Object src, Type dest) {
        Class<?> destClass = Types.raw(dest);
        return this.convert(src, destClass);
    }

    @Override
    public Object convert(ConversionRequest request) {
        if (request.destType() != null) {
            return this.convert(request.sourceObject(), request.destType());
        }
        return this.convert(request.sourceObject(), request.destClass());
    }

    @Override
    public void populateInputCandidates(Collection<Object> objects) {
        if (this.objectService == null) {
            return;
        }
        for (Object candidate : this.objectService.getObjects(this.getInputType())) {
            if (!this.canConvert(candidate, this.getOutputType())) continue;
            objects.add(candidate);
        }
    }

    @Override
    public boolean supports(ConversionRequest request) {
        return this.canConvert(request);
    }

    @Override
    public Class<ConversionRequest> getType() {
        return ConversionRequest.class;
    }

    @Override
    @Deprecated
    public boolean canConvert(Class<?> src, Type dest) {
        Class<?> destClass = Types.raw(dest);
        return this.canConvert(src, destClass);
    }
}

