/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script.process;

import java.util.Map;
import org.scijava.MenuPath;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.script.process.DirectiveScriptProcessor;
import org.scijava.script.process.ScriptProcessor;

@Plugin(type=ScriptProcessor.class)
public class ScriptDirectiveScriptProcessor
extends DirectiveScriptProcessor {
    @Parameter
    private LogService log;

    public ScriptDirectiveScriptProcessor() {
        super(directive -> "script".equals(directive));
    }

    @Override
    protected String process(String directive, Map<String, Object> attrs, String theRest) {
        for (String k : attrs.keySet()) {
            this.assignAttribute(k == null ? "name" : k, attrs.get(k));
        }
        return "";
    }

    private <T> void assignAttribute(String k, Object v) {
        if (this.is(k, "name")) {
            this.info().setName(this.as(v, String.class));
        } else if (this.is(k, "label")) {
            this.info().setLabel(this.as(v, String.class));
        } else if (this.is(k, "description")) {
            this.info().setDescription(this.as(v, String.class));
        } else if (this.is(k, "menuPath")) {
            this.info().setMenuPath(new MenuPath(this.as(v, String.class)));
        } else if (this.is(k, "menuRoot")) {
            this.info().setMenuRoot(this.as(v, String.class));
        } else if (this.is(k, "iconPath")) {
            this.info().setIconPath(this.as(v, String.class));
        } else if (this.is(k, "priority")) {
            Double priority = this.priority(v);
            if (priority != null) {
                this.info().setPriority(priority);
            }
        } else if (this.is(k, "headless") && this.as(v, Boolean.TYPE).booleanValue()) {
            this.info().set("headless", "true");
        } else {
            this.info().set(k, v.toString());
        }
    }

    private Double priority(Object p) {
        Double pDouble = this.as(p, Double.class);
        if (pDouble != null) {
            return pDouble;
        }
        String pString = this.as(p, String.class);
        if (pString == null) {
            return null;
        }
        String lString = pString.toLowerCase();
        if (lString.matches("first")) {
            return 1.0E300;
        }
        if (lString.matches("extremely[ _-]?high")) {
            return 1000000.0;
        }
        if (lString.matches("very[ _-]?high")) {
            return 10000.0;
        }
        if (lString.matches("high")) {
            return 100.0;
        }
        if (lString.matches("normal")) {
            return 0.0;
        }
        if (lString.matches("low")) {
            return -100.0;
        }
        if (lString.matches("very[ _-]?low")) {
            return -10000.0;
        }
        if (lString.matches("extremely[ _-]?low")) {
            return -1000000.0;
        }
        if (lString.matches("last")) {
            return -1.0E300;
        }
        return null;
    }
}

