/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.console;

import java.io.IOException;
import java.util.LinkedList;
import org.scijava.console.AbstractConsoleArgument;
import org.scijava.console.ConsoleArgument;
import org.scijava.display.DisplayService;
import org.scijava.io.IOService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=ConsoleArgument.class)
public class OpenArgument
extends AbstractConsoleArgument {
    @Parameter
    private IOService ioService;
    @Parameter
    private DisplayService displayService;
    @Parameter
    private LogService log;

    public OpenArgument() {
        super(2, "--open");
    }

    @Override
    public void handle(LinkedList<String> args) {
        if (!this.supports(args)) {
            return;
        }
        args.removeFirst();
        String source = args.removeFirst();
        try {
            Object o = this.ioService.open(source);
            this.displayService.createDisplay(o);
        }
        catch (IOException exc) {
            this.log.error(exc);
        }
    }
}

