/*
 * Decompiled with CFR 0.152.
 */
package org.scijava;

import java.util.ArrayList;
import java.util.Collection;
import org.scijava.MenuEntry;

public class MenuPath
extends ArrayList<MenuEntry> {
    private static final long serialVersionUID = 1L;
    public static final String PATH_SEPARATOR = ">";

    public MenuPath() {
    }

    public MenuPath(Collection<? extends MenuEntry> menuEntries) {
        if (menuEntries != null) {
            this.addAll(menuEntries);
        }
    }

    public MenuPath(String path) {
        this(path, PATH_SEPARATOR);
    }

    public MenuPath(String path, String separator) {
        this(path, separator, true);
    }

    public MenuPath(String path, String separator, boolean trim) {
        if (path != null && !path.isEmpty()) {
            String[] tokens;
            for (String token : tokens = path.split(separator)) {
                this.add(new MenuEntry(trim ? token.trim() : token));
            }
        }
    }

    public MenuEntry getLeaf() {
        if (this.size() == 0) {
            return null;
        }
        return (MenuEntry)this.get(this.size() - 1);
    }

    public String getMenuString() {
        return this.getMenuString(true);
    }

    public String getMenuString(boolean includeLeaf) {
        StringBuilder sb = new StringBuilder();
        int size = this.size();
        int last = includeLeaf ? size : size - 1;
        for (int i = 0; i < last; ++i) {
            MenuEntry menu = (MenuEntry)this.get(i);
            if (i > 0) {
                sb.append(" > ");
            }
            sb.append(menu);
        }
        return sb.toString();
    }
}

