/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.jnr.ffi.mapper;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import org.scijava.jython.shaded.jnr.ffi.mapper.FromNativeContext;
import org.scijava.jython.shaded.jnr.ffi.mapper.MethodParameterContext;
import org.scijava.jython.shaded.jnr.ffi.mapper.MethodResultContext;
import org.scijava.jython.shaded.jnr.ffi.mapper.SignatureType;
import org.scijava.jython.shaded.jnr.ffi.mapper.ToNativeContext;
import org.scijava.jython.shaded.jnr.ffi.util.Annotations;

public final class DefaultSignatureType
implements SignatureType {
    private final Class declaredClass;
    private final Collection<Annotation> annotations;
    private final Type genericType;

    public DefaultSignatureType(Class declaredClass, Collection<Annotation> annotations, Type genericType) {
        this.declaredClass = declaredClass;
        this.annotations = Annotations.sortedAnnotationCollection(annotations);
        this.genericType = genericType;
    }

    @Override
    public Class getDeclaredType() {
        return this.declaredClass;
    }

    @Override
    public Collection<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Type getGenericType() {
        return this.genericType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultSignatureType signature = (DefaultSignatureType)o;
        return this.declaredClass == signature.declaredClass && this.genericType.equals(signature.genericType) && this.annotations.equals(signature.annotations);
    }

    public int hashCode() {
        int result2 = this.declaredClass.hashCode();
        result2 = 31 * result2 + this.annotations.hashCode();
        if (this.genericType != null) {
            result2 = 31 * result2 + this.genericType.hashCode();
        }
        return result2;
    }

    public static DefaultSignatureType create(Class type, FromNativeContext context) {
        Class genericType = !type.isPrimitive() && context instanceof MethodResultContext ? ((MethodResultContext)context).getMethod().getGenericReturnType() : type;
        return new DefaultSignatureType(type, context.getAnnotations(), genericType);
    }

    public static DefaultSignatureType create(Class type, ToNativeContext context) {
        Type genericType = type;
        if (!type.isPrimitive() && context instanceof MethodParameterContext) {
            MethodParameterContext methodParameterContext = (MethodParameterContext)context;
            genericType = methodParameterContext.getMethod().getGenericParameterTypes()[methodParameterContext.getParameterIndex()];
        }
        return new DefaultSignatureType(type, context.getAnnotations(), genericType);
    }
}

