/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import javax.annotation.Nullable;
import org.python.google.common.annotations.GwtCompatible;
import org.python.google.common.collect.ImmutableMultiset;
import org.python.google.common.collect.ImmutableSet;
import org.python.google.common.collect.Multiset;
import org.python.google.common.collect.ObjectCountHashMap;
import org.python.google.common.primitives.Ints;
import org.python.google.errorprone.annotations.concurrent.LazyInit;

@GwtCompatible(serializable=true)
class RegularImmutableMultiset<E>
extends ImmutableMultiset<E> {
    static final RegularImmutableMultiset<Object> EMPTY = new RegularImmutableMultiset(ObjectCountHashMap.create());
    private final transient ObjectCountHashMap<E> contents;
    private final transient int size;
    @LazyInit
    private transient ImmutableSet<E> elementSet;

    RegularImmutableMultiset(ObjectCountHashMap<E> contents) {
        this.contents = contents;
        long size = 0L;
        for (int i = 0; i < contents.size(); ++i) {
            size += (long)contents.getValue(i);
        }
        this.size = Ints.saturatedCast(size);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int count(@Nullable Object element) {
        return this.contents.get(element);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ImmutableSet<E> elementSet() {
        ElementSet result2 = this.elementSet;
        return result2 == null ? (this.elementSet = new ElementSet()) : result2;
    }

    @Override
    Multiset.Entry<E> getEntry(int index) {
        return this.contents.getEntry(index);
    }

    private final class ElementSet
    extends ImmutableSet.Indexed<E> {
        private ElementSet() {
        }

        @Override
        E get(int index) {
            return RegularImmutableMultiset.this.contents.getKey(index);
        }

        @Override
        public boolean contains(@Nullable Object object) {
            return RegularImmutableMultiset.this.contains(object);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return RegularImmutableMultiset.this.contents.size();
        }
    }
}

