/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.jaxp.validation;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.python.apache.xerces.impl.xs.XMLSchemaLoader;
import org.python.apache.xerces.jaxp.validation.AbstractXMLSchema;
import org.python.apache.xerces.jaxp.validation.DraconianErrorHandler;
import org.python.apache.xerces.jaxp.validation.EmptyXMLSchema;
import org.python.apache.xerces.jaxp.validation.JAXPValidationMessageFormatter;
import org.python.apache.xerces.jaxp.validation.ReadOnlyGrammarPool;
import org.python.apache.xerces.jaxp.validation.SimpleXMLSchema;
import org.python.apache.xerces.jaxp.validation.Util;
import org.python.apache.xerces.jaxp.validation.WeakReferenceXMLSchema;
import org.python.apache.xerces.jaxp.validation.XMLSchema;
import org.python.apache.xerces.util.DOMEntityResolverWrapper;
import org.python.apache.xerces.util.DOMInputSource;
import org.python.apache.xerces.util.ErrorHandlerWrapper;
import org.python.apache.xerces.util.SAXInputSource;
import org.python.apache.xerces.util.SAXMessageFormatter;
import org.python.apache.xerces.util.SecurityManager;
import org.python.apache.xerces.util.StAXInputSource;
import org.python.apache.xerces.util.XMLGrammarPoolImpl;
import org.python.apache.xerces.xni.XNIException;
import org.python.apache.xerces.xni.grammars.Grammar;
import org.python.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.python.apache.xerces.xni.grammars.XMLGrammarPool;
import org.python.apache.xerces.xni.parser.XMLConfigurationException;
import org.python.apache.xerces.xni.parser.XMLInputSource;
import org.scijava.jython.shaded.javax.xml.stream.XMLEventReader;
import org.scijava.jython.shaded.javax.xml.transform.Source;
import org.scijava.jython.shaded.javax.xml.transform.dom.DOMSource;
import org.scijava.jython.shaded.javax.xml.transform.sax.SAXSource;
import org.scijava.jython.shaded.javax.xml.transform.stax.StAXSource;
import org.scijava.jython.shaded.javax.xml.transform.stream.StreamSource;
import org.scijava.jython.shaded.javax.xml.validation.Schema;
import org.scijava.jython.shaded.javax.xml.validation.SchemaFactory;
import org.scijava.jython.shaded.org.w3c.dom.Node;
import org.scijava.jython.shaded.org.w3c.dom.ls.LSResourceResolver;
import org.scijava.jython.shaded.org.xml.sax.ErrorHandler;
import org.scijava.jython.shaded.org.xml.sax.InputSource;
import org.scijava.jython.shaded.org.xml.sax.SAXException;
import org.scijava.jython.shaded.org.xml.sax.SAXNotRecognizedException;
import org.scijava.jython.shaded.org.xml.sax.SAXNotSupportedException;
import org.scijava.jython.shaded.org.xml.sax.SAXParseException;

public final class XMLSchemaFactory
extends SchemaFactory {
    private static final String JAXP_SOURCE_FEATURE_PREFIX = "http://javax.xml.transform";
    private static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String USE_GRAMMAR_POOL_ONLY = "http://apache.org/xml/features/internal/validation/schema/use-grammar-pool-only";
    private static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private final XMLSchemaLoader fXMLSchemaLoader = new XMLSchemaLoader();
    private ErrorHandler fErrorHandler;
    private LSResourceResolver fLSResourceResolver;
    private final DOMEntityResolverWrapper fDOMEntityResolverWrapper;
    private final ErrorHandlerWrapper fErrorHandlerWrapper = new ErrorHandlerWrapper(DraconianErrorHandler.getInstance());
    private SecurityManager fSecurityManager;
    private final XMLGrammarPoolWrapper fXMLGrammarPoolWrapper;
    private boolean fUseGrammarPoolOnly;

    public XMLSchemaFactory() {
        this.fDOMEntityResolverWrapper = new DOMEntityResolverWrapper();
        this.fXMLGrammarPoolWrapper = new XMLGrammarPoolWrapper();
        this.fXMLSchemaLoader.setFeature(SCHEMA_FULL_CHECKING, true);
        this.fXMLSchemaLoader.setProperty(XMLGRAMMAR_POOL, this.fXMLGrammarPoolWrapper);
        this.fXMLSchemaLoader.setEntityResolver(this.fDOMEntityResolverWrapper);
        this.fXMLSchemaLoader.setErrorHandler(this.fErrorHandlerWrapper);
        this.fUseGrammarPoolOnly = true;
    }

    public boolean isSchemaLanguageSupported(String string2) {
        if (string2 == null) {
            throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "SchemaLanguageNull", null));
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException(JAXPValidationMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "SchemaLanguageLengthZero", null));
        }
        return string2.equals("http://www.w3.org/2001/XMLSchema");
    }

    public LSResourceResolver getResourceResolver() {
        return this.fLSResourceResolver;
    }

    public void setResourceResolver(LSResourceResolver lSResourceResolver) {
        this.fLSResourceResolver = lSResourceResolver;
        this.fDOMEntityResolverWrapper.setEntityResolver(lSResourceResolver);
        this.fXMLSchemaLoader.setEntityResolver(this.fDOMEntityResolverWrapper);
    }

    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler;
        this.fErrorHandlerWrapper.setErrorHandler((ErrorHandler)(errorHandler != null ? errorHandler : DraconianErrorHandler.getInstance()));
        this.fXMLSchemaLoader.setErrorHandler(this.fErrorHandlerWrapper);
    }

    public Schema newSchema(Source[] sourceArray) throws SAXException {
        InputSource inputSource;
        Object object;
        XMLGrammarPoolImplExtension xMLGrammarPoolImplExtension = new XMLGrammarPoolImplExtension();
        this.fXMLGrammarPoolWrapper.setGrammarPool(xMLGrammarPoolImplExtension);
        XMLInputSource[] xMLInputSourceArray = new XMLInputSource[sourceArray.length];
        int n = 0;
        while (n < sourceArray.length) {
            String string2;
            Source source = sourceArray[n];
            if (source instanceof StreamSource) {
                object = (StreamSource)source;
                inputSource = object.getPublicId();
                string2 = object.getSystemId();
                InputStream inputStream = object.getInputStream();
                Reader reader = object.getReader();
                XMLInputSource xMLInputSource = new XMLInputSource((String)inputSource, string2, null);
                xMLInputSource.setByteStream(inputStream);
                xMLInputSource.setCharacterStream(reader);
                xMLInputSourceArray[n] = xMLInputSource;
            } else if (source instanceof SAXSource) {
                object = (SAXSource)source;
                inputSource = object.getInputSource();
                if (inputSource == null) {
                    throw new SAXException(JAXPValidationMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "SAXSourceNullInputSource", null));
                }
                xMLInputSourceArray[n] = new SAXInputSource(object.getXMLReader(), inputSource);
            } else if (source instanceof DOMSource) {
                object = (DOMSource)source;
                inputSource = object.getNode();
                string2 = object.getSystemId();
                xMLInputSourceArray[n] = new DOMInputSource((Node)inputSource, string2);
            } else if (source instanceof StAXSource) {
                object = (StAXSource)source;
                inputSource = object.getXMLEventReader();
                xMLInputSourceArray[n] = inputSource != null ? new StAXInputSource((XMLEventReader)inputSource) : new StAXInputSource(object.getXMLStreamReader());
            } else {
                if (source == null) {
                    throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "SchemaSourceArrayMemberNull", null));
                }
                throw new IllegalArgumentException(JAXPValidationMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "SchemaFactorySourceUnrecognized", new Object[]{source.getClass().getName()}));
            }
            ++n;
        }
        try {
            this.fXMLSchemaLoader.loadGrammar(xMLInputSourceArray);
        }
        catch (XNIException xNIException) {
            throw Util.toSAXException(xNIException);
        }
        catch (IOException iOException) {
            inputSource = new SAXParseException(iOException.getMessage(), null, (Exception)iOException);
            if (this.fErrorHandler != null) {
                this.fErrorHandler.error((SAXParseException)inputSource);
            }
            throw inputSource;
        }
        this.fXMLGrammarPoolWrapper.setGrammarPool(null);
        int n2 = xMLGrammarPoolImplExtension.getGrammarCount();
        object = null;
        if (this.fUseGrammarPoolOnly) {
            if (n2 > 1) {
                object = new XMLSchema(new ReadOnlyGrammarPool(xMLGrammarPoolImplExtension));
            } else if (n2 == 1) {
                inputSource = xMLGrammarPoolImplExtension.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
                object = new SimpleXMLSchema(inputSource[0]);
            } else {
                object = new EmptyXMLSchema();
            }
        } else {
            object = new XMLSchema(new ReadOnlyGrammarPool(xMLGrammarPoolImplExtension), false);
        }
        this.propagateFeatures((AbstractXMLSchema)object);
        return object;
    }

    public Schema newSchema() throws SAXException {
        WeakReferenceXMLSchema weakReferenceXMLSchema = new WeakReferenceXMLSchema();
        this.propagateFeatures(weakReferenceXMLSchema);
        return weakReferenceXMLSchema;
    }

    public Schema newSchema(XMLGrammarPool xMLGrammarPool) throws SAXException {
        XMLSchema xMLSchema = this.fUseGrammarPoolOnly ? new XMLSchema(new ReadOnlyGrammarPool(xMLGrammarPool)) : new XMLSchema(xMLGrammarPool, false);
        this.propagateFeatures(xMLSchema);
        return xMLSchema;
    }

    public boolean getFeature(String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string2 == null) {
            throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "FeatureNameNull", null));
        }
        if (string2.startsWith(JAXP_SOURCE_FEATURE_PREFIX) && (string2.equals("http://javax.xml.transform.stream.StreamSource/feature") || string2.equals("http://javax.xml.transform.sax.SAXSource/feature") || string2.equals("http://javax.xml.transform.dom.DOMSource/feature") || string2.equals("http://javax.xml.transform.stax.StAXSource/feature"))) {
            return true;
        }
        if (string2.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this.fSecurityManager != null;
        }
        if (string2.equals(USE_GRAMMAR_POOL_ONLY)) {
            return this.fUseGrammarPoolOnly;
        }
        try {
            return this.fXMLSchemaLoader.getFeature(string2);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string3 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "feature-not-recognized", new Object[]{string3}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "feature-not-supported", new Object[]{string3}));
        }
    }

    public Object getProperty(String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string2 == null) {
            throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "ProperyNameNull", null));
        }
        if (string2.equals(SECURITY_MANAGER)) {
            return this.fSecurityManager;
        }
        if (string2.equals(XMLGRAMMAR_POOL)) {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "property-not-supported", new Object[]{string2}));
        }
        try {
            return this.fXMLSchemaLoader.getProperty(string2);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string3 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "property-not-recognized", new Object[]{string3}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "property-not-supported", new Object[]{string3}));
        }
    }

    public void setFeature(String string2, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string2 == null) {
            throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "FeatureNameNull", null));
        }
        if (string2.startsWith(JAXP_SOURCE_FEATURE_PREFIX) && (string2.equals("http://javax.xml.transform.stream.StreamSource/feature") || string2.equals("http://javax.xml.transform.sax.SAXSource/feature") || string2.equals("http://javax.xml.transform.dom.DOMSource/feature") || string2.equals("http://javax.xml.transform.stax.StAXSource/feature"))) {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "feature-read-only", new Object[]{string2}));
        }
        if (string2.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            this.fSecurityManager = bl ? new SecurityManager() : null;
            this.fXMLSchemaLoader.setProperty(SECURITY_MANAGER, this.fSecurityManager);
            return;
        }
        if (string2.equals(USE_GRAMMAR_POOL_ONLY)) {
            this.fUseGrammarPoolOnly = bl;
            return;
        }
        try {
            this.fXMLSchemaLoader.setFeature(string2, bl);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string3 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "feature-not-recognized", new Object[]{string3}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "feature-not-supported", new Object[]{string3}));
        }
    }

    public void setProperty(String string2, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string2 == null) {
            throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "ProperyNameNull", null));
        }
        if (string2.equals(SECURITY_MANAGER)) {
            this.fSecurityManager = (SecurityManager)object;
            this.fXMLSchemaLoader.setProperty(SECURITY_MANAGER, this.fSecurityManager);
            return;
        }
        if (string2.equals(XMLGRAMMAR_POOL)) {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "property-not-supported", new Object[]{string2}));
        }
        try {
            this.fXMLSchemaLoader.setProperty(string2, object);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string3 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "property-not-recognized", new Object[]{string3}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "property-not-supported", new Object[]{string3}));
        }
    }

    private void propagateFeatures(AbstractXMLSchema abstractXMLSchema) {
        abstractXMLSchema.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", this.fSecurityManager != null);
        String[] stringArray = this.fXMLSchemaLoader.getRecognizedFeatures();
        int n = 0;
        while (n < stringArray.length) {
            boolean bl = this.fXMLSchemaLoader.getFeature(stringArray[n]);
            abstractXMLSchema.setFeature(stringArray[n], bl);
            ++n;
        }
    }

    static class XMLGrammarPoolWrapper
    implements XMLGrammarPool {
        private XMLGrammarPool fGrammarPool;

        XMLGrammarPoolWrapper() {
        }

        public Grammar[] retrieveInitialGrammarSet(String string2) {
            return this.fGrammarPool.retrieveInitialGrammarSet(string2);
        }

        public void cacheGrammars(String string2, Grammar[] grammarArray) {
            this.fGrammarPool.cacheGrammars(string2, grammarArray);
        }

        public Grammar retrieveGrammar(XMLGrammarDescription xMLGrammarDescription) {
            return this.fGrammarPool.retrieveGrammar(xMLGrammarDescription);
        }

        public void lockPool() {
            this.fGrammarPool.lockPool();
        }

        public void unlockPool() {
            this.fGrammarPool.unlockPool();
        }

        public void clear() {
            this.fGrammarPool.clear();
        }

        void setGrammarPool(XMLGrammarPool xMLGrammarPool) {
            this.fGrammarPool = xMLGrammarPool;
        }

        XMLGrammarPool getGrammarPool() {
            return this.fGrammarPool;
        }
    }

    static class XMLGrammarPoolImplExtension
    extends XMLGrammarPoolImpl {
        public XMLGrammarPoolImplExtension() {
        }

        public XMLGrammarPoolImplExtension(int n) {
            super(n);
        }

        int getGrammarCount() {
            return this.fGrammarCount;
        }
    }
}

