/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.linalg.Axis$_0$;
import breeze.linalg.Axis$_1$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Matrix;
import breeze.linalg.Matrix$mcD$sp;
import breeze.linalg.MatrixLike$mcD$sp;
import breeze.linalg.View;
import breeze.linalg.View$;
import breeze.linalg.View$Copy$;
import breeze.linalg.View$Prefer$;
import breeze.linalg.View$Require$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.support.CanMapValues;
import breeze.storage.Zero;
import breeze.util.ArrayUtil$;
import breeze.util.ReflectionUtil$;
import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class DenseMatrix$mcD$sp
extends DenseMatrix<Object>
implements Matrix$mcD$sp {
    private static final long serialVersionUID = 1L;
    public final double[] data$mcD$sp;

    @Override
    public final double apply(Tuple2<Object, Object> i) {
        return Matrix$mcD$sp.apply$(this, i);
    }

    @Override
    public final double apply$mcD$sp(Tuple2<Object, Object> i) {
        return Matrix$mcD$sp.apply$mcD$sp$(this, i);
    }

    @Override
    public final void update(Tuple2<Object, Object> i, double e) {
        Matrix$mcD$sp.update$(this, i, e);
    }

    @Override
    public final void update$mcD$sp(Tuple2<Object, Object> i, double e) {
        Matrix$mcD$sp.update$mcD$sp$(this, i, e);
    }

    @Override
    public <V2, That> That map(Function1<Object, V2> fn, CanMapValues<DenseMatrix<Object>, Object, V2, That> canMapValues) {
        return (That)MatrixLike$mcD$sp.map$(this, fn, canMapValues);
    }

    @Override
    public <V2, That> That map$mcD$sp(Function1<Object, V2> fn, CanMapValues<DenseMatrix<Object>, Object, V2, That> canMapValues) {
        return (That)MatrixLike$mcD$sp.map$mcD$sp$(this, fn, canMapValues);
    }

    @Override
    public double[] data$mcD$sp() {
        return this.data$mcD$sp;
    }

    public double[] data() {
        return this.data$mcD$sp();
    }

    @Override
    public double apply(int row, int col) {
        return this.apply$mcD$sp(row, col);
    }

    @Override
    public double apply$mcD$sp(int row, int col) {
        if (row < -this.rows() || row >= this.rows()) {
            throw new IndexOutOfBoundsException(new StringBuilder(19).append(new Tuple2.mcII.sp(row, col)).append(" not in [-").append(this.rows()).append(",").append(this.rows()).append(") x [-").append(this.cols()).append(",").append(this.cols()).append(")").toString());
        }
        if (col < -this.cols() || col >= this.cols()) {
            throw new IndexOutOfBoundsException(new StringBuilder(19).append(new Tuple2.mcII.sp(row, col)).append(" not in [-").append(this.rows()).append(",").append(this.rows()).append(") x [-").append(this.cols()).append(",").append(this.cols()).append(")").toString());
        }
        int trueRow = row < 0 ? row + this.rows() : row;
        int trueCol = col < 0 ? col + this.cols() : col;
        return this.data()[this.linearIndex(trueRow, trueCol)];
    }

    @Override
    public void update(int row, int col, double v) {
        this.update$mcD$sp(row, col, v);
    }

    @Override
    public void update$mcD$sp(int row, int col, double v) {
        if (row < -this.rows() || row >= this.rows()) {
            throw new IndexOutOfBoundsException(new StringBuilder(19).append(new Tuple2.mcII.sp(row, col)).append(" not in [-").append(this.rows()).append(",").append(this.rows()).append(") x [-").append(this.cols()).append(",").append(this.cols()).append(")").toString());
        }
        if (col < -this.cols() || col >= this.cols()) {
            throw new IndexOutOfBoundsException(new StringBuilder(19).append(new Tuple2.mcII.sp(row, col)).append(" not in [-").append(this.rows()).append(",").append(this.rows()).append(") x [-").append(this.cols()).append(",").append(this.cols()).append(")").toString());
        }
        int trueRow = row < 0 ? row + this.rows() : row;
        int trueCol = col < 0 ? col + this.cols() : col;
        this.data()[this.linearIndex((int)trueRow, (int)trueCol)] = v;
    }

    public double[] toArray() {
        return this.toArray$mcD$sp();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArray$mcD$sp() {
        double[] dArray;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        if (this.isContiguous() && !this.isTranspose()) {
            dArray = (double[])ArrayUtil$.MODULE$.copyOfRange(this.data(), this.offset(), this.offset() + this.size());
        } else {
            void var2_2;
            double[] ret = (double[])man.newArray(this.rows() * this.cols());
            int limit$macro$9 = this.cols();
            for (int index$macro$7 = 0; index$macro$7 < limit$macro$9; ++index$macro$7) {
                int limit$macro$4 = this.rows();
                for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
                    ((JFunction2.mcVII.sp & Serializable)(JFunction2.mcVII.sp & Serializable)(i, j) -> {
                        ret$2[i * $this.rows() + j] = this.data()[this.linearIndex(j, i)];
                    }).apply$mcVII$sp(index$macro$7, index$macro$2);
                }
            }
            dArray = var2_2;
        }
        return dArray;
    }

    @Override
    public DenseVector<Object> toDenseVector() {
        return this.toDenseVector$mcD$sp();
    }

    @Override
    public DenseVector<Object> toDenseVector$mcD$sp() {
        return DenseVector$.MODULE$.apply$mDc$sp(this.toArray$mcD$sp());
    }

    @Override
    public DenseVector<Object> flatten(View view) {
        return this.flatten$mcD$sp(view);
    }

    @Override
    public DenseVector<Object> flatten$mcD$sp(View view) {
        DenseVector<Object> denseVector;
        block4: {
            View view2;
            while (true) {
                if (View$Require$.MODULE$.equals(view2 = view)) {
                    if (!this.breeze$linalg$DenseMatrix$$canFlattenView()) {
                        throw new UnsupportedOperationException("Cannot make a view of this matrix.");
                    }
                    denseVector = DenseVector$.MODULE$.create(this.data(), this.offset(), 1, this.rows() * this.cols());
                    break block4;
                }
                if (View$Copy$.MODULE$.equals(view2)) {
                    denseVector = this.toDenseVector$mcD$sp();
                    break block4;
                }
                if (!View$Prefer$.MODULE$.equals(view2)) break;
                view = View$.MODULE$.viewPreferenceFromBoolean(this.breeze$linalg$DenseMatrix$$canFlattenView());
            }
            throw new MatchError((Object)view2);
        }
        return denseVector;
    }

    @Override
    public DenseMatrix<Object> reshape(int rows, int cols, View view) {
        return this.reshape$mcD$sp(rows, cols, view);
    }

    @Override
    public DenseMatrix<Object> reshape$mcD$sp(int rows, int cols, View view) {
        int _cols;
        block5: {
            View view2;
            while (true) {
                int right$macro$2;
                int left$macro$1;
                if ((left$macro$1 = rows * (_cols = cols)) != (right$macro$2 = this_.size())) {
                    throw new IllegalArgumentException(new StringBuilder(67).append("requirement failed: ").append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Cannot reshape a (%d,%d) matrix to a (%d,%d) matrix!"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this_.rows()), BoxesRunTime.boxToInteger((int)this_.cols()), BoxesRunTime.boxToInteger((int)rows), BoxesRunTime.boxToInteger((int)_cols)}))).append(": ").append("rows.*(_cols) == DenseMatrix.this.size (").append(left$macro$1).append(" ").append("!=").append(" ").append(right$macro$2).append(")").toString());
                }
                view2 = view;
                if (View$Require$.MODULE$.equals(view2)) {
                    if (!this_.breeze$linalg$DenseMatrix$$canReshapeView()) {
                        throw new UnsupportedOperationException("Cannot make a view of this matrix.");
                    }
                    break block5;
                }
                if (View$Copy$.MODULE$.equals(view2)) {
                    DenseMatrix$mcD$sp result = new DenseMatrix$mcD$sp(this_.rows(), this_.cols(), (double[])ArrayUtil$.MODULE$.newArrayLike(this_.data(), this_.size()));
                    result.$colon$eq(this_, HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM());
                    view = View$Require$.MODULE$;
                    cols = _cols;
                    DenseMatrix$mcD$sp this_ = result;
                    continue;
                }
                if (!View$Prefer$.MODULE$.equals(view2)) break;
                view = View$.MODULE$.viewPreferenceFromBoolean(this_.breeze$linalg$DenseMatrix$$canReshapeView());
            }
            throw new MatchError((Object)view2);
        }
        DenseMatrix$mcD$sp denseMatrix$mcD$sp = new DenseMatrix$mcD$sp(rows, _cols, this_.data(), this_.offset(), this_.isTranspose() ? cols : rows, this_.isTranspose());
        return denseMatrix$mcD$sp;
    }

    @Override
    public DenseMatrix<Object> repr() {
        return this.repr$mcD$sp();
    }

    @Override
    public DenseMatrix<Object> repr$mcD$sp() {
        return this;
    }

    @Override
    public double valueAt(int i) {
        return this.valueAt$mcD$sp(i);
    }

    @Override
    public double valueAt$mcD$sp(int i) {
        return this.data()[i];
    }

    @Override
    public double valueAt(int row, int col) {
        return this.valueAt$mcD$sp(row, col);
    }

    @Override
    public double valueAt$mcD$sp(int row, int col) {
        return this.apply$mcD$sp(row, col);
    }

    @Override
    public DenseMatrix<Object> toDenseMatrix(ClassTag<Object> cm, Zero<Object> zero) {
        return this.toDenseMatrix$mcD$sp(cm, zero);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DenseMatrix<Object> toDenseMatrix$mcD$sp(ClassTag<Object> cm, Zero<Object> zero) {
        void var3_3;
        Matrix result = DenseMatrix$.MODULE$.create$mDc$sp(this.rows(), this.cols(), (double[])cm.newArray(this.size()), (Zero)zero);
        ((DenseMatrix)result).$colon$eq(this, HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM());
        return var3_3;
    }

    @Override
    public DenseMatrix<Object> copy() {
        return this.copy$mcD$sp();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DenseMatrix<Object> copy$mcD$sp() {
        void var2_2;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        Matrix result = DenseMatrix$.MODULE$.create$mDc$sp(this.rows(), this.cols(), (double[])man.newArray(this.size()), this.breeze$linalg$DenseMatrix$$dontNeedZero());
        ((DenseMatrix)result).$colon$eq(this, HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM());
        return var2_2;
    }

    @Override
    public DenseMatrix<Object> delete(int row, Axis$_0$ axis) {
        return this.delete$mcD$sp(row, axis);
    }

    @Override
    public DenseMatrix<Object> delete$mcD$sp(int row, Axis$_0$ axis) {
        boolean cond$macro$1;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        boolean bl = cond$macro$1 = row >= 0 && row < this.rows();
        if (!cond$macro$1) {
            throw new IllegalArgumentException(new StringBuilder(64).append("requirement failed: ").append(new StringBuilder(28).append("row ").append(row).append(" is not in bounds: [0, ").append(this.rows()).append(")").toString()).append(": ").append("row.>=(0).&&(row.<(DenseMatrix.this.rows))").toString());
        }
        return row == 0 ? this.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.rows()), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows()).copy$mcD$sp() : (row == this.rows() - 1 ? this.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.rows() - 1), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows()).copy$mcD$sp() : DenseMatrix$.MODULE$.vertcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{this.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), row), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows()), this.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(row + 1), this.rows()), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows())}), HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM(), man, this.breeze$linalg$DenseMatrix$$dontNeedZero()));
    }

    @Override
    public DenseMatrix<Object> delete(int col, Axis$_1$ axis) {
        return this.delete$mcD$sp(col, axis);
    }

    @Override
    public DenseMatrix<Object> delete$mcD$sp(int col, Axis$_1$ axis) {
        boolean cond$macro$1;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        boolean bl = cond$macro$1 = col >= 0 && col < this.cols();
        if (!cond$macro$1) {
            throw new IllegalArgumentException(new StringBuilder(64).append("requirement failed: ").append(new StringBuilder(28).append("col ").append(col).append(" is not in bounds: [0, ").append(this.cols()).append(")").toString()).append(": ").append("col.>=(0).&&(col.<(DenseMatrix.this.cols))").toString());
        }
        return col == 0 ? this.apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.cols()), HasOps$.MODULE$.canSliceCols()).copy$mcD$sp() : (col == this.cols() - 1 ? this.apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.cols() - 1), HasOps$.MODULE$.canSliceCols()).copy$mcD$sp() : DenseMatrix$.MODULE$.horzcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{this.apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), col), HasOps$.MODULE$.canSliceCols()), this.apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(col + 1), this.cols()), HasOps$.MODULE$.canSliceCols())}), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM(), man, this.breeze$linalg$DenseMatrix$$dontNeedZero()));
    }

    @Override
    public DenseMatrix<Object> delete(Seq<Object> rows, Axis$_0$ axis) {
        return this.delete$mcD$sp(rows, axis);
    }

    @Override
    public DenseMatrix<Object> delete$mcD$sp(Seq<Object> rows, Axis$_0$ axis) {
        DenseMatrix<Object> denseMatrix;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        if (rows.isEmpty()) {
            denseMatrix = this.copy$mcD$sp();
        } else if (rows.size() == 1) {
            denseMatrix = this.delete$mcD$sp(BoxesRunTime.unboxToInt((Object)rows.apply(0)), axis);
        } else {
            boolean cond$macro$1;
            Seq sorted = (Seq)rows.sorted((Ordering)Ordering.Int$.MODULE$);
            boolean bl = cond$macro$1 = BoxesRunTime.unboxToInt((Object)sorted.head()) >= 0 && BoxesRunTime.unboxToInt((Object)sorted.last()) < this.rows();
            if (!cond$macro$1) {
                throw new IllegalArgumentException(new StringBuilder(68).append("requirement failed: ").append(new StringBuilder(29).append("row ").append(rows).append(" are not in bounds: [0, ").append(this.rows()).append(")").toString()).append(": ").append("sorted.head.>=(0).&&(sorted.last.<(this.rows))").toString());
            }
            IntRef last = IntRef.create((int)0);
            Builder matrices = breeze.collection.compat.package$.MODULE$.arraySeqBuilder(ClassTag$.MODULE$.apply(DenseMatrix.class));
            sorted.foreach((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
                boolean cond$macro$2;
                boolean bl = cond$macro$2 = index >= last$3.elem;
                if (!cond$macro$2) {
                    throw new AssertionError((Object)"assertion failed: index.>=(last)");
                }
                Object object = index != last$3.elem ? matrices.$plus$eq(this.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(last$3.elem), index), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows())) : BoxedUnit.UNIT;
                last$3.elem = index + 1;
            });
            Object object = last.elem != this.rows() ? matrices.$plus$eq(this.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(last.elem), this.rows()), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows())) : BoxedUnit.UNIT;
            denseMatrix = DenseMatrix$.MODULE$.vertcat((Seq)matrices.result(), HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM(), man, this.breeze$linalg$DenseMatrix$$dontNeedZero());
        }
        return denseMatrix;
    }

    @Override
    public DenseMatrix<Object> delete(Seq<Object> cols, Axis$_1$ axis) {
        return this.delete$mcD$sp(cols, axis);
    }

    @Override
    public DenseMatrix<Object> delete$mcD$sp(Seq<Object> cols, Axis$_1$ axis) {
        DenseMatrix<Object> denseMatrix;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        if (cols.isEmpty()) {
            denseMatrix = this.copy$mcD$sp();
        } else if (cols.size() == 1) {
            denseMatrix = this.delete$mcD$sp(BoxesRunTime.unboxToInt((Object)cols.apply(0)), axis);
        } else {
            boolean cond$macro$1;
            Seq sorted = (Seq)cols.sorted((Ordering)Ordering.Int$.MODULE$);
            boolean bl = cond$macro$1 = BoxesRunTime.unboxToInt((Object)sorted.head()) >= 0 && BoxesRunTime.unboxToInt((Object)sorted.last()) < this.cols();
            if (!cond$macro$1) {
                throw new IllegalArgumentException(new StringBuilder(68).append("requirement failed: ").append(new StringBuilder(29).append("col ").append(cols).append(" are not in bounds: [0, ").append(this.cols()).append(")").toString()).append(": ").append("sorted.head.>=(0).&&(sorted.last.<(this.cols))").toString());
            }
            IntRef last = IntRef.create((int)0);
            Builder matrices = breeze.collection.compat.package$.MODULE$.arraySeqBuilder(ClassTag$.MODULE$.apply(DenseMatrix.class));
            sorted.foreach((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
                boolean cond$macro$2;
                boolean bl = cond$macro$2 = index >= last$4.elem;
                if (!cond$macro$2) {
                    throw new AssertionError((Object)"assertion failed: index.>=(last)");
                }
                Object object = index != last$4.elem ? matrices.$plus$eq(this.apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(last$4.elem), index), HasOps$.MODULE$.canSliceCols())) : BoxedUnit.UNIT;
                last$4.elem = index + 1;
            });
            Object object = last.elem != this.cols() ? matrices.$plus$eq(this.apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(last.elem), this.cols()), HasOps$.MODULE$.canSliceCols())) : BoxedUnit.UNIT;
            denseMatrix = DenseMatrix$.MODULE$.horzcat((Seq)matrices.result(), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM(), man, this.breeze$linalg$DenseMatrix$$dontNeedZero());
        }
        return denseMatrix;
    }

    @Override
    public boolean overlaps(DenseMatrix<Object> other) {
        return this.overlaps$mcD$sp(other);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean overlaps$mcD$sp(DenseMatrix<Object> other) {
        if (this.data() != other.data$mcD$sp()) return false;
        int astart = this.offset();
        int aend = this.offset() + this.breeze$linalg$DenseMatrix$$footprint();
        int bstart = other.offset();
        int bend = other.offset() + other.breeze$linalg$DenseMatrix$$footprint();
        if (package$.MODULE$.Range().apply(astart, aend).contains(bstart)) return true;
        if (package$.MODULE$.Range().apply(astart, aend).contains(bend)) return true;
        if (package$.MODULE$.Range().apply(bstart, bend).contains(astart)) return true;
        if (!package$.MODULE$.Range().apply(bstart, bend).contains(aend)) return false;
        return true;
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    public DenseMatrix$mcD$sp(int rows, int cols, double[] data$mcD$sp, int offset, int majorStride, boolean isTranspose) {
        this.data$mcD$sp = data$mcD$sp;
        super(rows, cols, null, offset, majorStride, isTranspose);
        if (isTranspose && scala.math.package$.MODULE$.abs(majorStride) < cols && majorStride != 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(61).append("MajorStride == ").append(majorStride).append(" is smaller than cols == ").append(cols).append(", which is impossible").toString());
        }
        if (!isTranspose && scala.math.package$.MODULE$.abs(majorStride) < rows && majorStride != 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(61).append("MajorStride == ").append(majorStride).append(" is smaller than rows == ").append(rows).append(", which is impossible").toString());
        }
        if (rows < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(38).append("Rows must be larger than zero. It was ").append(rows).toString());
        }
        if (cols < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(38).append("Cols must be larger than zero. It was ").append(cols).toString());
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(40).append("Offset must be larger than zero. It was ").append(offset).toString());
        }
        if (majorStride > 0) {
            if (ScalaRunTime$.MODULE$.array_length(this.data()) < this.linearIndex(rows - 1, cols - 1)) {
                throw new IndexOutOfBoundsException(new StringBuilder(57).append("Storage array has size ").append(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.genericArrayOps(this.data()))).append(" but indices can grow as large as ").append(this.linearIndex(rows - 1, cols - 1)).toString());
            }
        } else if (majorStride < 0) {
            if (ScalaRunTime$.MODULE$.array_length(this.data()) < this.linearIndex(rows - 1, 0)) {
                throw new IndexOutOfBoundsException(new StringBuilder(57).append("Storage array has size ").append(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.genericArrayOps(this.data()))).append(" but indices can grow as large as ").append(this.linearIndex(rows - 1, cols - 1)).toString());
            }
            if (this.linearIndex(0, cols - 1) < 0) {
                throw new IndexOutOfBoundsException(new StringBuilder(84).append("Storage array has negative stride ").append(majorStride).append(" and offset ").append(offset).append(" which can result in negative indices.").toString());
            }
        }
        DenseMatrix$.MODULE$.breeze$linalg$DenseMatrix$$init();
    }

    public DenseMatrix$mcD$sp(int rows, int cols, ClassTag<Object> man) {
        this(rows, cols, (double[])man.newArray(rows * cols), 0, rows, DenseMatrix$.MODULE$.$lessinit$greater$default$6());
    }

    public DenseMatrix$mcD$sp(int rows, int cols, double[] data$mcD$sp, int offset) {
        this(rows, cols, data$mcD$sp, offset, rows, DenseMatrix$.MODULE$.$lessinit$greater$default$6());
    }

    public DenseMatrix$mcD$sp(int rows, int cols, double[] data$mcD$sp) {
        this(rows, cols, data$mcD$sp, 0, rows, DenseMatrix$.MODULE$.$lessinit$greater$default$6());
    }

    public DenseMatrix$mcD$sp(int rows, double[] data$mcD$sp, int offset) {
        int left$macro$1 = data$mcD$sp.length % rows;
        boolean right$macro$2 = false;
        if (left$macro$1 != 0) {
            throw new AssertionError((Object)new StringBuilder(49).append("assertion failed: ").append("data.length.%(rows) == 0 (").append(left$macro$1).append(" ").append("!=").append(" ").append(0).append(")").toString());
        }
        this(rows, data$mcD$sp.length / rows, data$mcD$sp, offset);
    }
}

