/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize;

import breeze.generic.UFunc;
import breeze.linalg.NumericOps;
import breeze.linalg.QuasiTensor;
import breeze.linalg.Tensor;
import breeze.linalg.TensorLike;
import breeze.linalg.norm$;
import breeze.linalg.operators.OpSub$;
import breeze.linalg.support.CanCopy;
import breeze.optimize.DiffFunction;
import breeze.stats.distributions.Rand$;
import breeze.util.LazyLogger;
import breeze.util.SerializableLogging;
import java.io.Serializable;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;

public final class GradientTester$
implements SerializableLogging {
    public static final GradientTester$ MODULE$ = new GradientTester$();
    private static volatile transient LazyLogger breeze$util$SerializableLogging$$_the_logger;

    static {
        SerializableLogging.$init$(MODULE$);
    }

    @Override
    public LazyLogger logger() {
        return SerializableLogging.logger$(this);
    }

    @Override
    public LazyLogger breeze$util$SerializableLogging$$_the_logger() {
        return breeze$util$SerializableLogging$$_the_logger;
    }

    @Override
    public void breeze$util$SerializableLogging$$_the_logger_$eq(LazyLogger x$1) {
        breeze$util$SerializableLogging$$_the_logger = x$1;
    }

    public <K, T> T test(DiffFunction<T> f, T x, double randFraction, boolean skipZeros, double epsilon, double tolerance, Function1<K, String> toString, .less.colon.less<T, NumericOps<T>> view2, .less.colon.less<T, Tensor<K, Object>> view, CanCopy<T> copy, UFunc.UImpl<norm$, T, Object> canNorm, UFunc.UImpl2<OpSub$, T, T, T> opSub) {
        IndexedSeq indices = Rand$.MODULE$.subsetsOfSize(((QuasiTensor)view.apply(x)).keysIterator().toIndexedSeq(), (int)((double)((TensorLike)view.apply(x)).size() * randFraction + 1.0)).get();
        return this.testIndices(f, x, (Iterable<K>)indices, skipZeros, toString, epsilon, tolerance, view2, view, copy, canNorm, opSub);
    }

    public <K, T> double test$default$3() {
        return 0.01;
    }

    public <K, T> boolean test$default$4() {
        return false;
    }

    public <K, T> double test$default$5() {
        return 1.0E-8;
    }

    public <K, T> double test$default$6() {
        return 0.001;
    }

    public <K, T> Function1<K, String> test$default$7() {
        return (Function1 & Serializable)x$1 -> x$1.toString();
    }

    public <T, K> T testIndices(DiffFunction<T> f, T x, Iterable<K> indices, boolean skipZeros, Function1<K, String> toString, double epsilon, double tolerance, .less.colon.less<T, NumericOps<T>> view2, .less.colon.less<T, Tensor<K, Object>> view, CanCopy<T> copy, UFunc.UImpl<norm$, T, Object> canNorm, UFunc.UImpl2<OpSub$, T, T, T> opSub) {
        Tuple2<Object, T> tuple2 = f.calculate(x);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double fx = tuple2._1$mcD$sp();
        Object trueGrad = tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)fx), trueGrad);
        Tuple2 tuple23 = tuple22;
        double fx2 = tuple23._1$mcD$sp();
        Object trueGrad2 = tuple23._2();
        Object xx = copy.apply(x);
        Object differences = opSub.apply(x, x);
        IntRef ok = IntRef.create((int)0);
        IntRef tried = IntRef.create((int)0);
        int sz = indices.size();
        indices.foreach((Function1 & Serializable)k -> {
            GradientTester$.$anonfun$testIndices$1(skipZeros, view, trueGrad2, toString, xx, epsilon, f, fx2, tolerance, ok, differences, tried, sz, x, k);
            return BoxedUnit.UNIT;
        });
        return differences;
    }

    public <T, K> boolean testIndices$default$4() {
        return false;
    }

    public <T, K> Function1<K, String> testIndices$default$5() {
        return (Function1 & Serializable)x$2 -> x$2.toString();
    }

    public <T, K> double testIndices$default$6() {
        return 1.0E-8;
    }

    public <T, K> double testIndices$default$7() {
        return 0.001;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GradientTester$.class);
    }

    public static final /* synthetic */ void $anonfun$testIndices$1(boolean skipZeros$1, .less.colon.less view$1, Object trueGrad$1, Function1 toString$1, Object xx$1, double epsilon$1, DiffFunction f$1, double fx$1, double tolerance$1, IntRef ok$1, Object differences$1, IntRef tried$1, int sz$1, Object x$4, Object k) {
        block4: {
            if (skipZeros$1 && BoxesRunTime.unboxToDouble(((TensorLike)view$1.apply(trueGrad$1)).apply(k)) == 0.0) {
                MODULE$.logger().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(11).append("Zero Grad: ").append(toString$1.apply(k)).toString());
                Predef$.MODULE$.print((Object)new StringBuilder(1).append((String)toString$1.apply(k)).append(" ").toString());
            } else {
                Tensor tensor = (Tensor)view$1.apply(xx$1);
                tensor.update(k, BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble(tensor.apply(k)) + epsilon$1)));
                double grad = (f$1.apply(xx$1) - fx$1) / epsilon$1;
                Tensor tensor2 = (Tensor)view$1.apply(xx$1);
                tensor2.update(k, BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble(tensor2.apply(k)) - epsilon$1)));
                double relDif = RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(grad - BoxesRunTime.unboxToDouble(((TensorLike)view$1.apply(trueGrad$1)).apply(k)))) / RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.max(RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(BoxesRunTime.unboxToDouble(((TensorLike)view$1.apply(trueGrad$1)).apply(k)))), RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(grad)))), 1.0E-4);
                if (relDif < tolerance$1) {
                    ++ok$1.elem;
                    MODULE$.logger().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(5).append("OK: ").append(toString$1.apply(k)).append(" ").append(relDif).toString());
                } else {
                    MODULE$.logger().warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append((String)toString$1.apply(k)).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" relDif: %.3e [eps : %e, calculated: %4.3e empirical: %4.3e]"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)relDif), BoxesRunTime.boxToDouble((double)epsilon$1), ((TensorLike)view$1.apply(trueGrad$1)).apply(k), BoxesRunTime.boxToDouble((double)grad)}))).toString());
                }
                ((TensorLike)view$1.apply(differences$1)).update(k, BoxesRunTime.boxToDouble((double)relDif));
                ++tried$1.elem;
            }
            if (tried$1.elem % 100 != 0 && tried$1.elem != sz$1) break block4;
            MODULE$.logger().info((Function0<String>)(Function0 & Serializable)() -> {
                Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)tried$1.elem);
                Integer arg$macro$2 = BoxesRunTime.boxToInteger((int)sz$1);
                Integer arg$macro$3 = BoxesRunTime.boxToInteger((int)((TensorLike)view$1.apply(x$4)).size());
                double arg$macro$4 = (double)ok$1.elem * 100.0 / (double)tried$1.elem;
                return StringOps$.MODULE$.format$extension("Checked %s of %s (out of dimension %s). %.4g%% ok.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3, BoxesRunTime.boxToDouble((double)arg$macro$4)}));
            });
        }
    }

    private GradientTester$() {
    }
}

