/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class RootFinding$ {
    public static final RootFinding$ MODULE$ = new RootFinding$();
    private static double eps;
    private static int defaultMaxIter;
    private static volatile byte bitmap$0;

    private double eps$lzycompute() {
        RootFinding$ rootFinding$ = this;
        synchronized (rootFinding$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                eps = package$.MODULE$.ulp(1.0);
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return eps;
    }

    public double eps() {
        return (byte)(bitmap$0 & 1) == 0 ? this.eps$lzycompute() : eps;
    }

    private int defaultMaxIter$lzycompute() {
        RootFinding$ rootFinding$ = this;
        synchronized (rootFinding$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                defaultMaxIter = 1000;
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return defaultMaxIter;
    }

    public int defaultMaxIter() {
        return (byte)(bitmap$0 & 2) == 0 ? this.defaultMaxIter$lzycompute() : defaultMaxIter;
    }

    public double find(Function1<Object, Object> fn, double x0, Option<Object> x1) {
        double xx1 = BoxesRunTime.unboxToDouble((Object)x1.orElse((Function0 & Serializable)() -> RootFinding$.findSecondEstimate$1(x0, fn)).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException("Automatic search of a second bracketing value failed");
        }));
        return this.brent(fn, x0, xx1);
    }

    public Option<Object> find$default$3() {
        return None$.MODULE$;
    }

    public double bisection(Function1<Object, Object> fn, double a, double b) {
        double fa = fn.apply$mcDD$sp(a);
        double fb = fn.apply$mcDD$sp(b);
        Predef$.MODULE$.require(RichDouble$.MODULE$.signum$extension(Predef$.MODULE$.doubleWrapper(fa)) != RichDouble$.MODULE$.signum$extension(Predef$.MODULE$.doubleWrapper(fb)), (Function0 & Serializable)() -> "The root is not bracketed by the given interval");
        return this.bis$1(a, b, fn, fa);
    }

    public double newtonRaphson(Function1<Object, Object> fn, Function1<Object, Object> fd, double x0, int maxIter) {
        return this.nr$1(x0, 0, fn, maxIter, fd);
    }

    public int newtonRaphson$default$4() {
        return this.defaultMaxIter();
    }

    public double secant(Function1<Object, Object> fn, double x0, double x1, int maxIter) {
        return this.se$1(x0, x1, 0, fn, maxIter);
    }

    public int secant$default$4() {
        return this.defaultMaxIter();
    }

    public double brent(Function1<Object, Object> fn, double a, double b) {
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(fn.apply$mcDD$sp(a), fn.apply$mcDD$sp(b));
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        double fa = sp2._1$mcD$sp();
        double fb = sp2._2$mcD$sp();
        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(fa, fb);
        Tuple2.mcDD.sp sp4 = sp3;
        double fa2 = sp4._1$mcD$sp();
        double fb2 = sp4._2$mcD$sp();
        Predef$.MODULE$.require(RichDouble$.MODULE$.signum$extension(Predef$.MODULE$.doubleWrapper(fa2)) != RichDouble$.MODULE$.signum$extension(Predef$.MODULE$.doubleWrapper(fb2)), (Function0 & Serializable)() -> "The root is not bracketed by the given interval");
        return this.brentAux$1(a, b, a, b - a, b - a, fa2, fb2, fa2, fn);
    }

    private static final Option findSecondEstimate$1(double x0, Function1 fn$1) {
        Seq search = (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{-0.01, 0.025, -0.05, 0.1, -0.25, 0.5, -1.0, 2.5, -5.0, 10.0, -50.0, 100.0, -500.0, 1000.0}));
        return search.view().map((Function1)(JFunction1.mcDD.sp & Serializable)s -> x0 + x0 * s).find((Function1)(JFunction1.mcZD.sp & Serializable)b -> fn$1.apply$mcDD$sp(x0) * fn$1.apply$mcDD$sp(b) <= 0.0);
    }

    private final double bis$1(double a, double b, Function1 fn$2, double fa$1) {
        double m;
        double fm;
        while (!(RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(fm = fn$2.apply$mcDD$sp(m = (a + b) / (double)2))) < (double)2 * this.eps())) {
            if (RichDouble$.MODULE$.signum$extension(Predef$.MODULE$.doubleWrapper(fm)) != RichDouble$.MODULE$.signum$extension(Predef$.MODULE$.doubleWrapper(fa$1))) {
                b = m;
                continue;
            }
            a = m;
        }
        return m;
    }

    private final double nr$1(double x, int iter, Function1 fn$3, int maxIter$1, Function1 fd$1) {
        while (!(RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(fn$3.apply$mcDD$sp(x))) < (double)2 * this.eps()) && iter != maxIter$1) {
            ++iter;
            x -= fn$3.apply$mcDD$sp(x) / fd$1.apply$mcDD$sp(x);
        }
        return x;
    }

    private final double se$1(double x0, double x1, int iter, Function1 fn$4, int maxIter$2) {
        while (!(RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(fn$4.apply$mcDD$sp(x1))) < (double)2 * this.eps()) && iter != maxIter$2) {
            double fx1 = fn$4.apply$mcDD$sp(x1);
            double d = x1;
            ++iter;
            x1 -= (x1 - x0) / (fx1 - fn$4.apply$mcDD$sp(x0)) * fx1;
            x0 = d;
        }
        return x1;
    }

    private final double brentAux$1(double aa, double bb, double cc, double dd, double ee, double ffa, double ffb, double ffc, Function1 fn$5) {
        while (true) {
            Tuple5 tuple5;
            if ((tuple5 = new Tuple5((Object)BoxesRunTime.boxToDouble((double)aa), (Object)BoxesRunTime.boxToDouble((double)bb), (Object)BoxesRunTime.boxToDouble((double)cc), (Object)BoxesRunTime.boxToDouble((double)dd), (Object)BoxesRunTime.boxToDouble((double)ee))) == null) {
                throw new MatchError((Object)tuple5);
            }
            double a = BoxesRunTime.unboxToDouble((Object)tuple5._1());
            double b = BoxesRunTime.unboxToDouble((Object)tuple5._2());
            double c = BoxesRunTime.unboxToDouble((Object)tuple5._3());
            double d = BoxesRunTime.unboxToDouble((Object)tuple5._4());
            double e = BoxesRunTime.unboxToDouble((Object)tuple5._5());
            Tuple5 tuple52 = new Tuple5((Object)BoxesRunTime.boxToDouble((double)a), (Object)BoxesRunTime.boxToDouble((double)b), (Object)BoxesRunTime.boxToDouble((double)c), (Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)e));
            Tuple5 tuple53 = tuple52;
            double a2 = BoxesRunTime.unboxToDouble((Object)tuple53._1());
            double b2 = BoxesRunTime.unboxToDouble((Object)tuple53._2());
            double c2 = BoxesRunTime.unboxToDouble((Object)tuple53._3());
            double d2 = BoxesRunTime.unboxToDouble((Object)tuple53._4());
            double e2 = BoxesRunTime.unboxToDouble((Object)tuple53._5());
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)ffa), (Object)BoxesRunTime.boxToDouble((double)ffb), (Object)BoxesRunTime.boxToDouble((double)ffc));
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            double fa = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double fb = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            double fc = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)fa), (Object)BoxesRunTime.boxToDouble((double)fb), (Object)BoxesRunTime.boxToDouble((double)fc));
            Tuple3 tuple33 = tuple32;
            double fa2 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
            double fb2 = BoxesRunTime.unboxToDouble((Object)tuple33._2());
            double fc2 = BoxesRunTime.unboxToDouble((Object)tuple33._3());
            if (fb2 == 0.0) {
                return b2;
            }
            if (RichDouble$.MODULE$.signum$extension(Predef$.MODULE$.doubleWrapper(fc2)) == RichDouble$.MODULE$.signum$extension(Predef$.MODULE$.doubleWrapper(fb2))) {
                c2 = a2;
                fc2 = fa2;
                e2 = d2 = b2 - a2;
            }
            if (RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(fc2)) < RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(fb2))) {
                a2 = b2;
                b2 = c2;
                c2 = a2;
                fa2 = fb2;
                fb2 = fc2;
                fc2 = fa2;
            }
            double m = 0.5 * (c2 - b2);
            double tol = (double)2 * this.eps() * package$.MODULE$.max(RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(b2)), 1.0);
            if (RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(m)) <= tol || fb2 == 0.0) {
                return b2;
            }
            if (RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(e2)) < tol || RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(fa2)) <= RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(fb2))) {
                e2 = m;
                d2 = m;
            } else {
                Tuple2.mcDD.sp sp2;
                Tuple2.mcDD.sp sp3;
                Tuple2.mcDD.sp sp4;
                Tuple2.mcDD.sp sp5;
                double s = fb2 / fa2;
                if (a2 == c2) {
                    sp5 = new Tuple2.mcDD.sp((double)2 * m * s, 1.0 - s);
                } else {
                    double q0 = fa2 / fc2;
                    double r = fb2 / fc2;
                    sp5 = sp4 = new Tuple2.mcDD.sp(s * ((double)2 * m * q0 * (q0 - r) - (b2 - a2) * (r - 1.0)), (q0 - 1.0) * (r - 1.0) * (s - 1.0));
                }
                if (sp4 == null) {
                    throw new MatchError((Object)sp4);
                }
                double p1 = sp4._1$mcD$sp();
                double q1 = sp4._2$mcD$sp();
                Tuple2.mcDD.sp sp6 = new Tuple2.mcDD.sp(p1, q1);
                Tuple2.mcDD.sp sp7 = sp6;
                double p12 = sp7._1$mcD$sp();
                double q12 = sp7._2$mcD$sp();
                Tuple2.mcDD.sp sp8 = sp3 = p12 > 0.0 ? new Tuple2.mcDD.sp(-q12, p12) : new Tuple2.mcDD.sp(q12, -p12);
                if (sp3 == null) {
                    throw new MatchError((Object)sp3);
                }
                double q = sp3._1$mcD$sp();
                double p = sp3._2$mcD$sp();
                Tuple2.mcDD.sp sp9 = new Tuple2.mcDD.sp(q, p);
                Tuple2.mcDD.sp sp10 = sp9;
                double q2 = sp10._1$mcD$sp();
                double p2 = sp10._2$mcD$sp();
                Tuple2.mcDD.sp sp11 = sp2 = (double)2 * p2 < (double)3 * m * q2 - RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(tol * q2)) && p2 < RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(0.5 * e2 * q2)) ? new Tuple2.mcDD.sp(p2 / q2, d2) : new Tuple2.mcDD.sp(m, m);
                if (sp2 == null) {
                    throw new MatchError((Object)sp2);
                }
                double td = sp2._1$mcD$sp();
                double te = sp2._2$mcD$sp();
                Tuple2.mcDD.sp sp12 = new Tuple2.mcDD.sp(td, te);
                Tuple2.mcDD.sp sp13 = sp12;
                double td2 = sp13._1$mcD$sp();
                double te2 = sp13._2$mcD$sp();
                d2 = td2;
                e2 = te2;
            }
            a2 = b2;
            fa2 = fb2;
            fb2 = fn$5.apply$mcDD$sp(b2 += RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(d2)) > tol ? d2 : (m > 0.0 ? tol : -tol));
            ffc = fc2;
            ffb = fb2;
            ffa = fa2;
            ee = e2;
            dd = d2;
            cc = c2;
            bb = b2;
            aa = a2;
        }
    }

    private RootFinding$() {
    }
}

