/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.generic.UFunc;
import breeze.linalg.CSCMatrix;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.Matrix;
import breeze.linalg.Matrix$mcI$sp;
import breeze.linalg.MatrixLike$mcI$sp;
import breeze.linalg.SparseVector;
import breeze.linalg.SparseVector$;
import breeze.linalg.SparseVector$mcI$sp;
import breeze.linalg.View;
import breeze.linalg.View$Copy$;
import breeze.linalg.View$Prefer$;
import breeze.linalg.View$Require$;
import breeze.linalg.mapValues$;
import breeze.storage.Zero;
import breeze.util.ArrayUtil$;
import breeze.util.ReflectionUtil$;
import java.util.Arrays;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ClassTag;

public class CSCMatrix$mcI$sp
extends CSCMatrix<Object>
implements Matrix$mcI$sp {
    public int[] _data$mcI$sp;
    public final Zero<Object> evidence$1$mcI$sp;
    private final int[] _rowIndices;

    @Override
    public final int apply(Tuple2<Object, Object> i) {
        return Matrix$mcI$sp.apply$(this, i);
    }

    @Override
    public final int apply$mcI$sp(Tuple2<Object, Object> i) {
        return Matrix$mcI$sp.apply$mcI$sp$(this, i);
    }

    @Override
    public final void update(Tuple2<Object, Object> i, int e) {
        Matrix$mcI$sp.update$(this, i, e);
    }

    @Override
    public final void update$mcI$sp(Tuple2<Object, Object> i, int e) {
        Matrix$mcI$sp.update$mcI$sp$(this, i, e);
    }

    @Override
    public <V2, That> That map(Function1<Object, V2> fn, UFunc.UImpl2<mapValues$, CSCMatrix<Object>, Function1<Object, V2>, That> canMapValues) {
        return (That)MatrixLike$mcI$sp.map$(this, fn, canMapValues);
    }

    @Override
    public <V2, That> That map$mcI$sp(Function1<Object, V2> fn, UFunc.UImpl2<mapValues$, CSCMatrix<Object>, Function1<Object, V2>, That> canMapValues) {
        return (That)MatrixLike$mcI$sp.map$mcI$sp$(this, fn, canMapValues);
    }

    @Override
    public int[] _data$mcI$sp() {
        return this._data$mcI$sp;
    }

    public int[] _data() {
        return this._data$mcI$sp();
    }

    @Override
    public void _data$mcI$sp_$eq(int[] x$1) {
        this._data$mcI$sp = x$1;
    }

    public void _data_$eq(int[] x$1) {
        this._data$mcI$sp_$eq(x$1);
    }

    public int[] data() {
        return this.data$mcI$sp();
    }

    @Override
    public int[] data$mcI$sp() {
        return this._data();
    }

    @Override
    public int apply(int row, int col) {
        return this.apply$mcI$sp(row, col);
    }

    @Override
    public int apply$mcI$sp(int row, int col) {
        if (row >= this.rows() || col >= this.cols() || row < 0 || col < 0) {
            throw new IndexOutOfBoundsException();
        }
        int ind = this.breeze$linalg$CSCMatrix$$locate(row, col);
        return ind < 0 ? this.zero$mcI$sp() : this.data$mcI$sp()[ind];
    }

    @Override
    public void update(int row, int col, int v) {
        this.update$mcI$sp(row, col, v);
    }

    @Override
    public void update$mcI$sp(int row, int col, int v) {
        if (row >= this.rows() || col >= this.cols() || row < 0 || col < 0) {
            throw new IndexOutOfBoundsException();
        }
        int ind = this.breeze$linalg$CSCMatrix$$locate(row, col);
        if (ind >= 0) {
            this.data$mcI$sp()[ind] = v;
        } else if (v != this.zero$mcI$sp()) {
            int insertPos = ~ind;
            this.used_$eq(this.used() + 1);
            if (this.used() > this.data$mcI$sp().length) {
                int newLength = this.data$mcI$sp().length == 0 ? 4 : (this.data$mcI$sp().length < 1024 ? this.data$mcI$sp().length * 2 : (this.data$mcI$sp().length < 2048 ? this.data$mcI$sp().length + 1024 : (this.data$mcI$sp().length < 4096 ? this.data$mcI$sp().length + 2048 : (this.data$mcI$sp().length < 8192 ? this.data$mcI$sp().length + 4096 : (this.data$mcI$sp().length < 16384 ? this.data$mcI$sp().length + 8192 : this.data$mcI$sp().length + 16384)))));
                int[] newIndex = Arrays.copyOf(this.rowIndices(), newLength);
                int[] newData = (int[])ArrayUtil$.MODULE$.copyOf(this.data$mcI$sp(), newLength);
                System.arraycopy(this.breeze$linalg$CSCMatrix$$_rowIndices(), insertPos, newIndex, insertPos + 1, this.used() - insertPos - 1);
                System.arraycopy(this.data$mcI$sp(), insertPos, newData, insertPos + 1, this.used() - insertPos - 1);
                this.breeze$linalg$CSCMatrix$$_rowIndices_$eq(newIndex);
                this._data_$eq(newData);
            } else if (this.used() - insertPos > 1) {
                System.arraycopy(this.breeze$linalg$CSCMatrix$$_rowIndices(), insertPos, this.breeze$linalg$CSCMatrix$$_rowIndices(), insertPos + 1, this.used() - insertPos - 1);
                System.arraycopy(this.data$mcI$sp(), insertPos, this.data$mcI$sp(), insertPos + 1, this.used() - insertPos - 1);
            }
            this.rowIndices()[insertPos] = row;
            this.data$mcI$sp()[insertPos] = v;
            int end$macro$3 = this.cols();
            for (int index$macro$2 = col + 1; index$macro$2 <= end$macro$3; ++index$macro$2) {
                this.colPtrs()[index$macro$2] = this.colPtrs()[index$macro$2] + 1;
            }
        }
    }

    @Override
    public CSCMatrix<Object> repr() {
        return this.repr$mcI$sp();
    }

    @Override
    public CSCMatrix<Object> repr$mcI$sp() {
        return this;
    }

    @Override
    public int zero() {
        return this.zero$mcI$sp();
    }

    @Override
    public int zero$mcI$sp() {
        return ((Zero)Predef$.MODULE$.implicitly(this.evidence$1$mcI$sp)).zero$mcI$sp();
    }

    @Override
    public void use(CSCMatrix<Object> matrix) {
        this.use$mcI$sp(matrix);
    }

    @Override
    public void use$mcI$sp(CSCMatrix<Object> matrix) {
        this.use$mcI$sp(matrix.data$mcI$sp(), matrix.colPtrs(), matrix.rowIndices(), matrix.used());
    }

    public void use(int[] data, int[] colPtrs, int[] rowIndices, int used) {
        this.use$mcI$sp(data, colPtrs, rowIndices, used);
    }

    @Override
    public void use$mcI$sp(int[] data, int[] colPtrs, int[] rowIndices, int used) {
        boolean cond$macro$5;
        boolean cond$macro$4;
        boolean cond$macro$3;
        int left$macro$1 = colPtrs.length;
        int right$macro$2 = this.colPtrs().length;
        if (left$macro$1 != right$macro$2) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append(new StringBuilder(44).append("colPtrs.length == this.colPtrs.length (").append(left$macro$1).append(" ").append("!=").append(" ").append(right$macro$2).append(")").toString()).toString());
        }
        boolean bl = cond$macro$3 = used >= 0;
        if (!cond$macro$3) {
            throw new IllegalArgumentException("requirement failed: used.>=(0)");
        }
        boolean bl2 = cond$macro$4 = data.length >= used;
        if (!cond$macro$4) {
            throw new IllegalArgumentException("requirement failed: data.length.>=(used)");
        }
        boolean bl3 = cond$macro$5 = rowIndices.length >= used;
        if (!cond$macro$5) {
            throw new IllegalArgumentException("requirement failed: rowIndices.length.>=(used)");
        }
        this._data_$eq(data);
        System.arraycopy(colPtrs, 0, this.colPtrs(), 0, colPtrs.length);
        this.breeze$linalg$CSCMatrix$$_rowIndices_$eq(rowIndices);
        this.used_$eq(used);
    }

    @Override
    public CSCMatrix<Object> copy() {
        return this.copy$mcI$sp();
    }

    @Override
    public CSCMatrix<Object> copy$mcI$sp() {
        return new CSCMatrix$mcI$sp((int[])ArrayUtil$.MODULE$.copyOf(this._data(), this.activeSize()), this.rows(), this.cols(), (int[])this.colPtrs().clone(), this.activeSize(), (int[])this.breeze$linalg$CSCMatrix$$_rowIndices().clone(), this.evidence$1$mcI$sp);
    }

    @Override
    public SparseVector<Object> flatten(View view) {
        return this.flatten$mcI$sp(view);
    }

    @Override
    public SparseVector<Object> flatten$mcI$sp(View view) {
        SparseVector<Object> sparseVector;
        View view2 = view;
        if (View$Require$.MODULE$.equals(view2)) {
            int[] indices = new int[this.data$mcI$sp().length];
            int ind = 0;
            for (int j = 0; j < this.cols(); ++j) {
                int ip = this.colPtrs()[j];
                while (ip < this.colPtrs()[j + 1]) {
                    int i = this.rowIndices()[ip];
                    indices[ind] = i * this.rows() + j;
                    ++ip;
                    ++ind;
                }
            }
            sparseVector = new SparseVector$mcI$sp(indices, this.data$mcI$sp(), this.activeSize(), this.rows() * this.cols(), this.evidence$1$mcI$sp);
        } else if (View$Copy$.MODULE$.equals(view2)) {
            ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data$mcI$sp());
            SparseVector<Object> sv = SparseVector$.MODULE$.zeros$mIc$sp(this.rows() * this.cols(), man, this.evidence$1$mcI$sp);
            for (int j = 0; j < this.cols(); ++j) {
                for (int ip = this.colPtrs()[j]; ip < this.colPtrs()[j + 1]; ++ip) {
                    int i = this.rowIndices()[ip];
                    sv.update$mcI$sp(i * this.cols() + j, this.data$mcI$sp()[ip]);
                }
            }
            sparseVector = sv;
        } else if (View$Prefer$.MODULE$.equals(view2)) {
            sparseVector = this.flatten$mcI$sp(View$Require$.MODULE$);
        } else {
            throw new MatchError((Object)view2);
        }
        return sparseVector;
    }

    @Override
    public DenseMatrix<Object> toDenseMatrix(ClassTag<Object> cm, Zero<Object> zero) {
        return this.toDenseMatrix$mcI$sp(cm, zero);
    }

    @Override
    public DenseMatrix<Object> toDenseMatrix$mcI$sp(ClassTag<Object> cm, Zero<Object> zero) {
        return this.toDense$mcI$sp();
    }

    @Override
    public DenseMatrix<Object> toDense() {
        return this.toDense$mcI$sp();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DenseMatrix<Object> toDense$mcI$sp() {
        void var2_2;
        ClassTag ctg = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data$mcI$sp());
        Matrix res = DenseMatrix$.MODULE$.zeros$mIc$sp(this.rows(), this.cols(), ctg, (Zero)this.evidence$1$mcI$sp);
        for (int i = 0; i < this.cols(); ++i) {
            for (int j = this.colPtrs()[i]; j < this.colPtrs()[i + 1]; ++j) {
                ((DenseMatrix)res).update$mcI$sp(this.rowIndices()[j], i, this.data$mcI$sp()[j]);
            }
        }
        return var2_2;
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    public CSCMatrix$mcI$sp(int[] _data$mcI$sp, int rows, int cols, int[] colPtrs, int used, int[] _rowIndices, Zero<Object> evidence$1$mcI$sp) {
        this._data$mcI$sp = _data$mcI$sp;
        this.evidence$1$mcI$sp = evidence$1$mcI$sp;
        this._rowIndices = _rowIndices;
        super(_data$mcI$sp, rows, cols, colPtrs, used, _rowIndices, evidence$1$mcI$sp);
    }

    public CSCMatrix$mcI$sp(int[] data$mcI$sp, int rows, int cols, int[] colPtrs, int[] rowIndices, Zero<Object> evidence$2$mcI$sp) {
        this(data$mcI$sp, rows, cols, colPtrs, data$mcI$sp.length, rowIndices, evidence$2$mcI$sp);
    }
}

